<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\VisitorAttendance;
use App\Models\Purchase;
use App\Models\PurchaseDetail;
use App\Models\PtPurchase;
use App\Models\Product;
use App\Models\Member; 


class DashboardController extends Controller
{
    
    public function index()
    {
        if (auth()->user()->role !== 'admin') {
            return redirect()->route('purchases.index');
        }
        $today = Carbon::today();
        $startMonth = Carbon::now()->startOfMonth();
        $endMonth = Carbon::now()->endOfMonth();

        // 1. Pendapatan Visit
        $visitDaily = VisitorAttendance::where('tanggal', $today)->sum('harga');
        $visitMonthly = VisitorAttendance::whereBetween('tanggal', [$startMonth, $endMonth])->sum('harga');

        // 2. Pendapatan Produk (kecuali Member Card)
        $produkDaily = PurchaseDetail::whereHas('purchase', function($q) use ($today) {
                $q->whereDate('tanggal', $today);
            })
            ->whereHas('product', function($q) {
                $q->where('nama', '!=', 'Member Card'); // Ganti 'nama' jika beda
            })
            ->get()
            ->sum(function($item) {
                return $item->harga_satuan * $item->qty;
            });

        $produkMonthly = PurchaseDetail::whereHas('purchase', function($q) use ($startMonth, $endMonth) {
                $q->whereBetween('tanggal', [$startMonth, $endMonth]);
            })
            ->whereHas('product', function($q) {
                $q->where('nama', '!=', 'Member Card'); // Ganti 'nama' jika beda
            })
            ->get()
            ->sum(function($item) {
                return $item->harga_satuan * $item->qty;
            });

        // 3. Pendapatan Member Card
        $memberCardDaily = PurchaseDetail::whereHas('purchase', function($q) use ($today) {
                $q->whereDate('tanggal', $today);
            })
            ->whereHas('product', function($q) {
                $q->where('nama', 'Member Card'); // Ganti 'nama' jika beda
            })
            ->get()
            ->sum(function($item) {
                return $item->harga_satuan * $item->qty;
            });

        $memberCardMonthly = PurchaseDetail::whereHas('purchase', function($q) use ($startMonth, $endMonth) {
                $q->whereBetween('tanggal', [$startMonth, $endMonth]);
            })
            ->whereHas('product', function($q) {
                $q->where('nama', 'Member Card'); // Ganti 'nama' jika beda
            })
            ->get()
            ->sum(function($item) {
                return $item->harga_satuan * $item->qty;
            });

        // 4. Pendapatan PT
        $ptDaily = PtPurchase::where('tanggal', $today)->sum('harga');
        $ptMonthly = PtPurchase::whereBetween('tanggal', [$startMonth, $endMonth])->sum('harga');
        $members = Member::all();

        return view('dashboard', [
            'daily' => [
                'visit' => $visitDaily,
                'produk' => $produkDaily,
                'member_card' => $memberCardDaily,
                'pt' => $ptDaily,
            ],
            'monthly' => [
                'visit' => $visitMonthly,
                'produk' => $produkMonthly,
                'member_card' => $memberCardMonthly,
                'pt' => $ptMonthly,
            ],
            'members' => $members
        ]);
       // }
    }
}