
<?php $__env->startSection('title', 'Dashboard Penagihan'); ?>

<?php $__env->startSection('content'); ?>
<style>
    /* Custom card dashboard */
    .my-dashboard-card {
        border-radius: 1rem;
        box-shadow: 0 3px 8px rgba(0,0,0,0.08);
        min-height: 120px;
        margin-bottom: 1.2rem;
        background: #f7fafd;
        transition: box-shadow .18s;
        border: none;
        display: flex;
        align-items: center;
        position: relative;
    }
    .my-dashboard-card .icon {
        font-size: 2.5rem;
        position: absolute;
        top: 1.1rem;
        right: 1.4rem;
        opacity: 0.18;
        z-index: 0;
        pointer-events: none;
    }
    .my-dashboard-card .card-body {
        position: relative;
        z-index: 1;
        padding-top: 0.9rem;
        padding-bottom: 0.9rem;
    }
    .dashboard-value {
        font-size: 1.8rem;
        font-weight: bold;
        margin-bottom: .2rem;
        line-height: 1.1;
    }
    .dashboard-label {
        font-size: 1.08rem;
        font-weight: 600;
        margin-bottom: .37rem;
        letter-spacing: 0.5px;
    }
    .soft-blue { background: #e3f0fa; color:#1565c0;}
    .soft-green { background: #eafbe7; color:#388e3c;}
    .soft-yellow { background: #fffde7; color:#fbc02d;}
    .soft-red { background: #fde7e7; color:#c62828;}
    .soft-grey { background: #f5f5f5; color:#616161;}
    .icon-blue { color:#1565c0; }
    .icon-green { color:#388e3c;}
    .icon-yellow { color:#fbc02d;}
    .icon-red { color:#c62828;}
    .icon-grey { color:#616161;}
    @media (max-width: 600px) {
        .dashboard-value { font-size: 1.1rem; }
        .dashboard-label { font-size: 0.92rem; }
        .my-dashboard-card { min-height: 80px; }
    }
    /* Custom table */
    .table-dashboard {
        font-size: 0.96rem;
        border-radius: 0.9em;
        overflow: hidden;
        background: #fff;
        box-shadow: 0 2px 10px rgba(0,0,0,.07);
    }
    .table-dashboard thead {
        background: linear-gradient(90deg,#c62828 60%,#fbc02d 100%);
        color: #fff;
        font-size: 1.02rem;
    }
    .table-dashboard th, .table-dashboard td {
        vertical-align: middle !important;
    }
    .table-dashboard tbody tr:nth-child(even) {
        background: #f7fafd;
    }
    .table-dashboard tbody tr:hover {
        background: #e3f0fa;
        transition: background .15s;
    }
    .badge-status {
        font-size: 0.9em;
        border-radius: 0.5em;
        padding: 0.35em 0.9em;
        font-weight: 500;
        letter-spacing: .3px;
    }
    .badge-lunas { background: #388e3c; color: #fff; }
    .badge-belumlunas { background: #c62828; color: #fff;}
    .badge-suspend { background: #c62828; color: #fff;}
    .foto-rumah {
        max-width:40px;max-height:40px;object-fit:cover;border-radius:7px;border:1px solid #eee;
    }
</style>
<div class="container-fluid">
    <h3 class="mb-4 fw-bold text-dark"><i class="fas fa-file-invoice-dollar me-2"></i>Dashboard Penagihan</h3>
    <div class="row">
        <div class="col-lg-3 col-md-4 col-6">
            <div class="card my-dashboard-card soft-blue">
                <span class="icon icon-blue"><i class="fas fa-money-check-alt"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Total Tagihan Bulan Ini</div>
                    <div class="dashboard-value">Rp<?php echo e(number_format($totalTagihanBulanIni,0,',','.')); ?></div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-4 col-6">
            <div class="card my-dashboard-card soft-green">
                <span class="icon icon-green"><i class="fas fa-check-circle"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Tagihan Sudah Dibayar</div>
                    <div class="dashboard-value">Rp<?php echo e(number_format($tagihanSudahDibayar,0,',','.')); ?></div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-4 col-6">
            <div class="card my-dashboard-card soft-yellow">
                <span class="icon icon-yellow"><i class="fas fa-exclamation-triangle"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Tagihan Belum Dibayar</div>
                    <div class="dashboard-value">Rp<?php echo e(number_format($tagihanBelumDibayar,0,',','.')); ?></div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-4 col-6">
            <div class="card my-dashboard-card soft-red">
                <span class="icon icon-red"><i class="fas fa-user-times"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Pelanggan Suspend</div>
                    <div class="dashboard-value"><?php echo e($jumlahSuspend); ?></div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-4 col-6">
            <div class="card my-dashboard-card soft-grey">
                <span class="icon icon-grey"><i class="fas fa-users"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Pelanggan Belum Bayar</div>
                    <div class="dashboard-value"><?php echo e($jumlahBelumBayar); ?></div>
                </div>
            </div>
        </div>
    </div>

    <!-- TABEL PELANGGAN BELUM LUNAS -->
    <div class="card mt-4">
        <div class="card-header bg-danger text-white">
            <i class="fas fa-list"></i> Daftar Pelanggan Belum Lunas Bulan Ini
            <input type="text" id="filterBelumLunas" class="form-control form-control-sm w-auto d-inline-block float-end" placeholder="Cari nama/alamat..." style="max-width:220px;">
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-dashboard table-hover mb-0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Nama</th>
                            <th>Grub</th>
                            <th>Alamat</th>
                            <th>No HP</th>
                            <th>Paket</th>
                            <th>Tagihan</th>
                            <th>Status</th>
                            <!--<th>Foto</th>-->
                        </tr>
                    </thead>
                    <tbody id="belumLunasTableBody">
                        <?php $__empty_1 = true; $__currentLoopData = $pelangganBelumLunas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><strong><?php echo e($p->nama); ?></strong></td>
                            <td><?php echo e($p->nama_grub ?? '-'); ?></td>
                            <td><?php echo e($p->alamat); ?></td>
                            <td>
                                <a href="https://wa.me/<?php echo e(preg_replace('/[^0-9]/','',$p->no_hp)); ?>" target="_blank" class="text-success">
                                    <i class="fab fa-whatsapp"></i> <?php echo e($p->no_hp); ?>

                                </a>
                            </td>
                            <td><?php echo e($p->paket_wifi); ?></td>
                            <td>Rp<?php echo e(number_format($p->jumlah_tagihan,0,',','.')); ?></td>
                            <td>
                                <?php if($p->status == 'belum_lunas'): ?>
                                    <span class="badge badge-status badge-belumlunas">Belum Lunas</span>
                                <?php elseif($p->status == 'suspend'): ?>
                                    <span class="badge badge-status badge-suspend">Suspend</span>
                                <?php else: ?>
                                    <span class="badge badge-status badge-lunas">Lunas</span>
                                <?php endif; ?>
                            </td>
                            <!--<td>
                                <?php if($p->foto_rumah): ?>
                                    <img src="<?php echo e(asset('storage/' . $p->foto_rumah)); ?>" class="foto-rumah" alt="Foto Rumah">
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>-->
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center text-danger">Tidak ada pelanggan belum lunas.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
document.getElementById('filterBelumLunas').addEventListener('keyup', function() {
    let filter = this.value.toLowerCase();
    let rows = document.querySelectorAll('#belumLunasTableBody tr');
    rows.forEach(function(row) {
        let nama = row.cells[1]?.innerText.toLowerCase();
        let alamat = row.cells[3]?.innerText.toLowerCase();
        row.style.display = (nama?.includes(filter) || alamat?.includes(filter)) ? '' : 'none';
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\billing_mgmt\resources\views/dashboard/penagihan.blade.php ENDPATH**/ ?>