
<?php $__env->startSection('title', 'Stok Opname Alat'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="mb-3 d-flex justify-content-between">
        <?php if($canCrud): ?>
            <button class="btn btn-success btn-sm" data-toggle="modal" data-target="#modalTambah">+ Tambah Alat</button>
        <?php endif; ?>
        <!-- Filter Form -->
        <form method="GET" class="form-inline" action="<?php echo e(route('stok-opname.index')); ?>">
            <input type="text" name="q" class="form-control form-control-sm mr-2" placeholder="Nama/Serial" value="<?php echo e(request('q')); ?>">
            <input type="date" name="tanggal_masuk" class="form-control form-control-sm mr-2" placeholder="Tgl Masuk" value="<?php echo e(request('tanggal_masuk')); ?>">
            <input type="date" name="tanggal_keluar" class="form-control form-control-sm mr-2" placeholder="Tgl Keluar" value="<?php echo e(request('tanggal_keluar')); ?>">
            <select name="teknisi_id" class="form-control form-control-sm mr-2">
                <option value="">Teknisi</option>
                <?php $__currentLoopData = \App\Models\User::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teknisi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($teknisi->id); ?>" <?php echo e(request('teknisi_id') == $teknisi->id ? 'selected' : ''); ?>><?php echo e($teknisi->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <button type="submit" class="btn btn-primary btn-sm">Filter</button>
        </form>
    </div>

    <div class="card">
        <div class="card-header bg-primary text-white">
            <h3 class="card-title">Stok Opname Alat</h3>
        </div>
        <div class="card-body p-2">
            <table class="table table-sm table-bordered table-hover">
                <thead class="bg-light">
                    <tr>
                        <th style="width: 30px;">No</th>
                        <th style="width: 130px;">Nama Alat</th>
                        <th style="width: 100px;">Serial</th>
                        <th style="width: 70px;">Status</th>
                        <th style="width: 90px;">Teknisi</th>
                        <th style="width: 90px;">Tgl Keluar</th>
                        <th style="width: 90px;">Tgl Masuk</th>
                        <?php if($canCrud): ?>
                        <th style="width: 80px;">Aksi</th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $alat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $no => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($no + $alat->firstItem()); ?></td>
                            <td><?php echo e($item->nama_alat); ?></td>
                            <td><?php echo e($item->serial_number); ?></td>
                            <td><?php echo e(ucfirst($item->status)); ?></td>
                            <td><?php echo e($item->teknisi ? $item->teknisi->name : '-'); ?></td>
                            <td><?php echo e($item->tanggal_keluar); ?></td>
                            <td><?php echo e($item->tanggal_masuk); ?></td>
                            <?php if($canCrud): ?>
                            <td>
                                <button class="btn btn-warning btn-xs"
                                  data-toggle="modal"
                                  data-target="#modalEdit<?php echo e($item->id); ?>">
                                  Edit
                                </button>
                                <button class="btn btn-danger btn-xs"
                                  data-toggle="modal"
                                  data-target="#modalDelete<?php echo e($item->id); ?>">
                                  Hapus
                                </button>
                            </td>
                            <?php endif; ?>
                        </tr>

                        <!-- Modal Edit Alat -->
                        <div class="modal fade" id="modalEdit<?php echo e($item->id); ?>" tabindex="-1" role="dialog">
                          <div class="modal-dialog" role="document">
                            <form method="POST" action="<?php echo e(route('stok-opname.update', $item->id)); ?>">
                              <?php echo csrf_field(); ?>
                              <?php echo method_field('PUT'); ?>
                              <div class="modal-content">
                                <div class="modal-header">
                                  <h5 class="modal-title">Edit Alat</h5>
                                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                  </button>
                                </div>
                                <div class="modal-body">
                                  <!-- Isi sama seperti sebelumnya -->
                                  <div class="mb-2">
                                    <label>Nama Alat</label>
                                    <input type="text" name="nama_alat" class="form-control"
                                      value="<?php echo e($item->nama_alat); ?>" required>
                                  </div>
                                  <div class="mb-2">
                                    <label>Serial Number</label>
                                    <input type="text" name="serial_number" class="form-control"
                                      value="<?php echo e($item->serial_number); ?>">
                                  </div>
                                  <div class="mb-2">
                                    <label>Status</label>
                                    <select name="status" class="form-control" required>
                                      <option value="stok" <?php echo e($item->status == 'stok' ? 'selected' : ''); ?>>Stok</option>
                                      <option value="keluar" <?php echo e($item->status == 'keluar' ? 'selected' : ''); ?>>Keluar</option>
                                      <!--<option value="masuk" <?php echo e($item->status == 'masuk' ? 'selected' : ''); ?>>Masuk</option>-->
                                    </select>
                                  </div>
                                  <div class="mb-2">
                                    <label>Keluar Untuk</label>
                                    <input type="text" name="keluar_untuk" class="form-control"
                                      value="<?php echo e($item->keluar_untuk); ?>">
                                  </div>
                                  <div class="mb-2">
                                    <label>Teknisi</label>
                                    <select name="teknisi_id" class="form-control">
                                      <option value="">-</option>
                                      <?php $__currentLoopData = \App\Models\User::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teknisi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($teknisi->id); ?>"
                                          <?php echo e($item->teknisi_id == $teknisi->id ? 'selected' : ''); ?>>
                                          <?php echo e($teknisi->name); ?>

                                        </option>
                                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                  </div>
                                  <div class="mb-2">
                                    <label>Tanggal Keluar</label>
                                    <input type="date" name="tanggal_keluar" class="form-control"
                                      value="<?php echo e($item->tanggal_keluar); ?>">
                                  </div>
                                  <div class="mb-2">
                                    <label>Tanggal Masuk</label>
                                    <input type="date" name="tanggal_masuk" class="form-control"
                                      value="<?php echo e($item->tanggal_masuk); ?>">
                                  </div>
                                  <div class="mb-2">
                                    <label>Sumber Masuk</label>
                                    <select name="sumber_masuk" class="form-control">
                                      <option value="">-</option>
                                      <option value="pembelian" <?php echo e($item->sumber_masuk == 'pembelian' ? 'selected' : ''); ?>>Pembelian</option>
                                      <option value="pelanggan_berhenti" <?php echo e($item->sumber_masuk == 'pelanggan_berhenti' ? 'selected' : ''); ?>>Pelanggan Berhenti</option>
                                    </select>
                                  </div>
                                  <div class="mb-2">
                                    <label>Keterangan</label>
                                    <textarea name="keterangan" class="form-control"><?php echo e($item->keterangan); ?></textarea>
                                  </div>
                                </div>
                                <div class="modal-footer">
                                  <button type="submit" class="btn btn-success btn-sm">Simpan</button>
                                  <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Batal</button>
                                </div>
                              </div>
                            </form>
                          </div>
                        </div>

                        <!-- Modal Delete Alat -->
                        <div class="modal fade" id="modalDelete<?php echo e($item->id); ?>" tabindex="-1" role="dialog">
                          <div class="modal-dialog" role="document">
                            <form method="POST" action="<?php echo e(route('stok-opname.destroy', $item->id)); ?>">
                              <?php echo csrf_field(); ?>
                              <?php echo method_field('DELETE'); ?>
                              <div class="modal-content">
                                <div class="modal-header">
                                  <h5 class="modal-title">Konfirmasi Hapus</h5>
                                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                  </button>
                                </div>
                                <div class="modal-body">
                                  <p>Yakin ingin menghapus alat <strong><?php echo e($item->nama_alat); ?> (<?php echo e($item->serial_number); ?>)</strong>?</p>
                                </div>
                                <div class="modal-footer">
                                  <button type="submit" class="btn btn-danger btn-sm">Hapus</button>
                                  <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Batal</button>
                                </div>
                              </div>
                            </form>
                          </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                          <td colspan="8" class="text-center">Data tidak ditemukan.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <div class="d-flex justify-content-center">
                <?php echo e($alat->links()); ?>

            </div>
            <br>
            Nb : keluar alat / masuk alat secod lewat menu edit. menu tambah untuk alat pembelian baru. 
        </div>
    </div>
</div>

<!-- Modal Tambah Alat -->
<?php if($canCrud): ?>
<div class="modal fade" id="modalTambah" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <form method="POST" action="<?php echo e(route('stok-opname.store')); ?>">
      <?php echo csrf_field(); ?>
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Tambah Alat</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <!-- Isi sama seperti sebelumnya -->
          <div class="mb-2">
            <label>Nama Alat</label>
            <input type="text" name="nama_alat" class="form-control" required>
          </div>
          <div class="mb-2">
            <label>Serial Number</label>
            <input type="text" name="serial_number" class="form-control">
          </div>
          <div class="mb-2">
            <label>Status</label>
            <select name="status" class="form-control" required>
              <option value="stok">Stok</option>
              <option value="keluar">Keluar</option>
              <!--<option value="masuk">Masuk</option>-->
            </select>
          </div>
          <div class="mb-2">
            <label>Keluar Untuk</label>
            <input type="text" name="keluar_untuk" class="form-control">
          </div>
          <div class="mb-2">
            <label>Teknisi</label>
            <select name="teknisi_id" class="form-control">
              <option value="">-</option>
              <?php $__currentLoopData = \App\Models\User::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teknisi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($teknisi->id); ?>"><?php echo e($teknisi->name); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
          <div class="mb-2">
            <label>Tanggal Keluar</label>
            <input type="date" name="tanggal_keluar" class="form-control">
          </div>
          <div class="mb-2">
            <label>Tanggal Masuk</label>
            <input type="date" name="tanggal_masuk" class="form-control">
          </div>
          <div class="mb-2">
            <label>Sumber Masuk</label>
            <select name="sumber_masuk" class="form-control">
              <option value="">-</option>
              <option value="pembelian">Pembelian</option>
              <option value="pelanggan_berhenti">Pelanggan Berhenti</option>
            </select>
          </div>
          <div class="mb-2">
            <label>Keterangan</label>
            <textarea name="keterangan" class="form-control"></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success btn-sm">Tambah</button>
          <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Batal</button>
        </div>
      </div>
    </form>
  </div>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\billing_mgmt\resources\views/stok_opname/index.blade.php ENDPATH**/ ?>