

<?php $__env->startSection('title', 'Data Pelanggan'); ?>

<?php $__env->startSection('content'); ?>
<style>
    .sort-arrow {
        color: #fff !important;
        font-weight: bold;
        text-decoration: none;
        font-size: 1.2em;
        margin-left: 2px;
        margin-right: 2px;
        vertical-align: middle;
        transition: color 0.2s;
    }
    .sort-arrow:hover {
        color: #add8e6 !important;
    }
    @media (max-width: 600px) {
        .table th, .table td {
            font-size: 13px !important;
            padding: 6px 4px !important;
        }
        .table th {
            white-space: nowrap;
        }
        .table td {
            vertical-align: middle;
        }
        .badge, .btn {
            font-size: 12px !important;
            padding: 4px 8px !important;
        }
        .form-control, .btn {
            font-size: 13px !important;
        }
    }
</style>
<div class="container">
    <h2 class="mb-3">Data Pelanggan</h2>
    <div class="row mb-3 align-items-center">
        <div class="col-auto mb-2 mb-md-0">
            <a href="<?php echo e(route('pelanggan.create')); ?>" class="btn btn-primary btn-sm">Tambah Pelanggan</a>
        </div>
        <div class="col-auto mb-2 mb-md-0">
            <a href="<?php echo e(route('pembayaran.generate_tagihan')); ?>" class="btn btn-success btn-sm"
               onclick="return confirm('Generate tagihan untuk semua pelanggan bulan ini?')">
               Generate Tagihan Bulan Ini
            </a>
        </div>
        <div class="col">
            <form method="GET" action="<?php echo e(route('pelanggan.index')); ?>" class="form-row justify-content-end">
                <div class="col-12 col-md-auto mb-2 mb-md-0">
                    <input type="text" name="q" class="form-control form-control-sm" placeholder="Cari Nama Grub" value="<?php echo e(request('q')); ?>">
                </div>
                <div class="col-12 col-md-auto mb-2 mb-md-0">
                    <select name="status" class="form-control form-control-sm">
                        <option value="">-- Status Tagihan --</option>
                        <option value="lunas" <?php echo e(request('status') == 'lunas' ? 'selected' : ''); ?>>Lunas</option>
                        <option value="belum_lunas" <?php echo e(request('status') == 'belum_lunas' ? 'selected' : ''); ?>>Belum Lunas</option>
                    </select>
                </div>
                <div class="col-12 col-md-auto">
                    <button type="submit" class="btn btn-primary btn-sm mr-1">Filter</button>
                    <a href="<?php echo e(route('pelanggan.index')); ?>" class="btn btn-secondary btn-sm">Reset</a>
                </div>
            </form>
        </div>
    </div>
    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <div class="card shadow-sm">
        <div class="card-body p-2">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped table-sm mb-0 align-middle">
                    <thead class="bg-gradient-primary text-white text-center">
                        <tr>
                            <th style="width:40px;">No</th>
                            <th>Nama Grub</th>
                            <th>Jumlah Pelanggan</th>
                            <th class="text-right">Jumlah Tagihan (Rp)</th>
                            <th class="text-right">
                                Tagihan Belum Lunas (Rp)
                                <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'belum_lunas_asc'])); ?>" title="Urutkan naik" class="sort-arrow">▲</a>
                                <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'belum_lunas_desc'])); ?>" title="Urutkan turun" class="sort-arrow">▼</a>
                            </th>
                            <th>Status Tagihan</th>
                            <th style="width:70px;">Detail</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $grubs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $allPayments = $grub->pelanggans->flatMap->pembayaran;
                            $total_tagihan = $allPayments->sum('jumlah_tagihan');
                            $total_tagihan_belum_lunas = $allPayments
                                ->where('status', 'belum_lunas')
                                ->sum(function($p) {
                                    return max(0, $p->jumlah_tagihan - ($p->jumlah_dibayar ?? 0));
                                });
                        ?>
                        <tr>
                            <td><?php echo e($loop->iteration + ($grubs->currentPage()-1)*$grubs->perPage()); ?></td>
                            <td style="min-width:120px"><?php echo e($grub->nama_grub); ?></td>
                            <td class="text-center"><?php echo e($grub->pelanggans_count); ?></td>
                            <td class="text-right"><?php echo e(number_format($total_tagihan, 0, ',', '.')); ?></td>
                            <td class="text-right"><?php echo e(number_format($total_tagihan_belum_lunas, 0, ',', '.')); ?></td>
                            <td>
                                <?php if($total_tagihan_belum_lunas > 0): ?>
                                    <span class="badge badge-warning text-dark w-100">Tagihan Belum Lunas</span>
                                <?php else: ?>
                                    <span class="badge badge-success w-100">Semua Lunas</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?php echo e(route('grubs.show', $grub->id)); ?>" class="btn btn-info btn-sm w-100">Detail</a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center">Data grub tidak ditemukan.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-2 mb-0">
                <?php echo e($grubs->appends(request()->except('page'))->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\billing_mgmt\resources\views/pelanggan/index.blade.php ENDPATH**/ ?>