

<?php $__env->startSection('title', 'Peta Topologi Jaringan'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Peta Topologi Jaringan</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card card-primary">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h3 class="card-title">Jaringan Pelanggan & Site</h3>
                <form id="filterForm" class="form-inline">
                    <label for="siteFilter" class="mr-2">Filter Site:</label>
                    <select id="siteFilter" class="form-control">
                        <option value="">Semua Site</option>
                        <?php $__currentLoopData = $sites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $site): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($site->id); ?>"><?php echo e($site->nama_site); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </form>
            </div>
            <div class="card-body" style="height: 600px; padding:0;">
                <div id="map" style="height: 100%; width: 100%;"></div>
                <!-- Legend -->
                <div id="legend" style="position:absolute; bottom:20px; right:30px; z-index:1000; background:rgba(255,255,255,0.95); border-radius:8px; box-shadow:0 2px 8px #aaa; padding:12px;">
                    <b>Keterangan:</b><br>
                    <img src="https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-blue.png" style="width:18px;"> Site<br>
                    <img src="https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-green.png" style="width:18px;"> Pelanggan Aktif<br>
                    <img src="https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-red.png" style="width:18px;"> Pelanggan Suspend<br>
                    <span style="display:inline-block; width:24px; height:4px; background:blue; margin-right:5px; vertical-align:middle;"></span> Koneksi ke Site
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"/>
    <style>
        .leaflet-container { font-size: 1rem; }
        #legend { font-size: 0.95rem; }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script>
    var sites = <?php echo json_encode($sites, 15, 512) ?>;
    var pelanggans = <?php echo json_encode($pelanggans, 15, 512) ?>;

    var map = L.map('map').setView([-7.47, 110.9], 13);

    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap'
    }).addTo(map);

    // Leaflet color markers
    var greenIcon = new L.Icon({
        iconUrl: 'https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-green.png',
        shadowUrl: 'https://cdnjs.cloudflare.com/ajax/libs/leaflet/1.7.1/images/marker-shadow.png',
        iconSize: [25, 41],
        iconAnchor: [12, 41],
        popupAnchor: [1, -34],
        shadowSize: [41, 41]
    });

    var redIcon = new L.Icon({
        iconUrl: 'https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-red.png',
        shadowUrl: 'https://cdnjs.cloudflare.com/ajax/libs/leaflet/1.7.1/images/marker-shadow.png',
        iconSize: [25, 41],
        iconAnchor: [12, 41],
        popupAnchor: [1, -34],
        shadowSize: [41, 41]
    });

    var blueIcon = new L.Icon({
        iconUrl: 'https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-blue.png',
        shadowUrl: 'https://cdnjs.cloudflare.com/ajax/libs/leaflet/1.7.1/images/marker-shadow.png',
        iconSize: [25, 41],
        iconAnchor: [12, 41],
        popupAnchor: [1, -34],
        shadowSize: [41, 41]
    });

    var siteMarkers = {};
    var siteMarkerObjects = [];
    var pelangganMarkerObjects = [];
    var polylineObjects = [];

    function renderMap(selectedSiteId = null) {
        // Bersihkan marker & garis lama
        siteMarkerObjects.forEach(m => map.removeLayer(m));
        pelangganMarkerObjects.forEach(m => map.removeLayer(m));
        polylineObjects.forEach(l => map.removeLayer(l));
        siteMarkerObjects = [];
        pelangganMarkerObjects = [];
        polylineObjects = [];
        siteMarkers = {};

        // Marker site (warna biru)
        sites.forEach(function(site) {
            if(!site.lokasi_site) return;
            if(selectedSiteId && site.id != selectedSiteId) return;
            var coords = site.lokasi_site.split(',');
            var lat = parseFloat(coords[0]);
            var lng = parseFloat(coords[1]);
            var marker = L.marker([lat, lng], {icon: blueIcon})
                .addTo(map)
                .bindPopup('<b>Site:</b> ' + site.nama_site + '<br>' + (site.keterangan ?? ''));
            siteMarkers[site.id] = [lat, lng];
            siteMarkerObjects.push(marker);

            if(selectedSiteId) {
                map.setView([lat, lng], 15);
            }
        });

        // Marker pelanggan dan polyline ke site
        pelanggans.forEach(function(p) {
            if(!p.koordinat_lokasi || !p.site_id) return;
            if(selectedSiteId && p.site_id != selectedSiteId) return;
            var pcoords = p.koordinat_lokasi.split(',');
            var plat = parseFloat(pcoords[0]);
            var plng = parseFloat(pcoords[1]);
            var icon = (p.status == 'aktif' ? greenIcon : redIcon);
            var marker = L.marker([plat, plng], {icon: icon})
                .addTo(map)
                .bindPopup('<b>Pelanggan:</b> ' + p.nama + '<br>' + p.alamat + '<br>Status: <b>' + p.status + '</b>');
            pelangganMarkerObjects.push(marker);

            // Garis ke site
            if(siteMarkers[p.site_id]) {
                var siteCoord = siteMarkers[p.site_id];
                var line = L.polyline([
                    [plat, plng],
                    siteCoord
                ], {color: 'blue', weight: 2, opacity: 0.7}).addTo(map);
                polylineObjects.push(line);
            }
        });
    }

    // Initial render
    renderMap();

    // Filter site
    document.getElementById('siteFilter').addEventListener('change', function() {
        var val = this.value;
        renderMap(val ? parseInt(val) : null);
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\billing_mgmt\resources\views/network_map/index.blade.php ENDPATH**/ ?>