
<?php $__env->startSection('title', 'Dashboard Admin'); ?>

<?php $__env->startSection('content'); ?>
<style>
    .dashboard-card {
        border: none;
        border-radius: 1.1rem;
        box-shadow: 0 4px 16px rgba(0,0,0,.08);
        min-height: 150px;
        position: relative;
        overflow: hidden;
        background: #f7fafd;
        transition: transform .18s, box-shadow .18s;
    }
    .dashboard-card:hover {
        transform: translateY(-4px) scale(1.01);
        box-shadow: 0 10px 32px rgba(0,0,0,.15);
        z-index: 2;
    }
    .dashboard-card .icon {
        font-size: 2.8rem;
        position: absolute;
        top: 1.1rem;
        right: 1.3rem;
        opacity: 0.25;
        z-index: 0;
        transition: opacity .18s;
    }
    .dashboard-card:hover .icon {
        opacity: 0.32;
    }
    .dashboard-card .card-body {
        z-index: 1;
        position: relative;
        padding-top: 1.1rem;
    }
    .dashboard-value {
        font-size: 1.8rem;
        font-weight: bold;
        line-height: 1.1;
        margin-bottom: .2rem;
    }
    .dashboard-label {
        font-size: 1.13rem;
        font-weight: 600;
        margin-bottom: .37rem;
        letter-spacing: 0.5px;
    }
    /* Soft highlight colors */
    .soft-blue { background: #e3f0fa; color:#1565c0;}
    .soft-red { background: #fde7e7; color:#c62828;}
    .soft-cyan { background: #e0f7fa; color:#00838f;}
    .soft-green { background: #eafbe7; color:#388e3c;}
    .soft-yellow { background: #fffde7; color:#fbc02d;}
    .soft-orange { background: #fff3e0; color:#f57c00;}
    .soft-grey { background: #f5f5f5; color:#616161;}
    /* Icon colors (with better contrast) */
    .icon-blue { color:#1565c0; }
    .icon-red { color:#c62828; }
    .icon-cyan { color:#00838f;}
    .icon-green { color:#388e3c;}
    .icon-yellow { color:#fbc02d;}
    .icon-orange { color:#f57c00;}
    .icon-grey { color:#616161;}
    /* Responsive */
    @media (max-width: 600px) {
        .dashboard-value { font-size: 1.5rem; }
        .dashboard-label { font-size: 1rem; }
        .dashboard-card { min-height: 90px; }
    }
        /* Table styling */
        .table-dashboard {
        font-size: 0.98rem;
        border-radius: 1em;
        overflow: hidden;
        background: #fff;
        box-shadow: 0 2px 10px rgba(0,0,0,.08);
    }
    .table-dashboard thead {
        background: linear-gradient(90deg,#2196f3 60%,#00bcd4 100%);
        color: #fff;
        font-size: 1.03rem;
    }
    .table-dashboard th, .table-dashboard td {
        vertical-align: middle !important;
    }
    .table-dashboard tbody tr:nth-child(even) {
        background: #f7fafd;
    }
    .table-dashboard tbody tr:hover {
        background: #e3f0fa;
        transition: background .15s;
    }
    .badge-suspend {
        background: #c62828;
        color: #fff;
        font-size: 0.85em;
        border-radius: 0.5em;
        padding: 0.4em 0.8em;
        font-weight: 500;
        letter-spacing: .3px;
    }
    .table-dashboard .foto-rumah {
        max-width:50px;max-height:50px;object-fit:cover;border-radius:10px;border:1px solid #eee;
    }
</style>
<div class="container-fluid">
    <h3 class="mb-4 fw-bold text-dark"><i class="fas fa-tachometer-alt me-2"></i>Dashboard Admin</h3>
    <div class="row g-3">
        <!-- Pelanggan Aktif -->
        <div class="col-lg-3 col-md-4 col-6">
            <a href="/list-pelanggan" class="card dashboard-card soft-blue">
                <span class="icon icon-blue"><i class="fas fa-users"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Pelanggan Aktif</div>
                    <div class="dashboard-value"><?php echo e($totalAktif); ?></div>
                </div>
            </a>
        </div>
        <!-- Pelanggan Suspend -->
        <div class="col-lg-3 col-md-4 col-6">
            <a href="/list-pelanggan" class="card dashboard-card soft-red">
                <span class="icon icon-red"><i class="fas fa-user-slash"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Pelanggan Suspend</div>
                    <div class="dashboard-value"><?php echo e($totalSuspend); ?></div>
                </div>
            </a>
        </div>
        <!-- Tagihan Bulan Ini -->
        <div class="col-lg-3 col-md-4 col-6">
            <a href="/pelanggan" class="card dashboard-card soft-cyan">
                <span class="icon icon-cyan"><i class="fas fa-file-invoice-dollar"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Tagihan Bulan Ini</div>
                    <div class="dashboard-value">Rp <?php echo e(number_format($totalTagihanBulanIni)); ?></div>
                </div>
            </a>
        </div>
        <!-- Tagihan Sudah Dibayar (Bulan Ini) -->
        <div class="col-lg-3 col-md-4 col-6">
            <a href="/pelanggan" class="card dashboard-card soft-green">
                <span class="icon icon-green"><i class="fas fa-check-circle"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Tagihan Sudah Dibayar <br><small>(Bulan Ini)</small></div>
                    <div class="dashboard-value">Rp <?php echo e(number_format($totalDibayarBulanIni)); ?></div>
                </div>
            </a>
        </div>
        <!-- Tagihan Belum Dibayar Akumulasi -->
        <div class="col-lg-4 col-md-6 col-12">
            <a href="/pelanggan" class="card dashboard-card soft-yellow">
                <span class="icon icon-yellow"><i class="fas fa-exclamation-circle"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Tagihan Belum Dibayar <br><small>(Akumulasi)</small></div>
                    <div class="dashboard-value">Rp <?php echo e(number_format($totalBelumDibayar)); ?></div>
                </div>
            </a>
        </div>
        <!-- Tagihan Belum Dibayar Suspend -->
        <div class="col-lg-4 col-md-6 col-12">
            <a href="/pelanggan" class="card dashboard-card soft-orange">
                <span class="icon icon-orange"><i class="fas fa-ban"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Tagihan Belum Dibayar <br><small>(Suspend)</small></div>
                    <div class="dashboard-value">Rp <?php echo e(number_format($totalBelumDibayarSuspend)); ?></div>
                </div>
            </a>
        </div>
        <!-- Total Upah Teknisi -->
        <div class="col-lg-4 col-12">
            <a href="/rekap-upah" class="card dashboard-card soft-grey">
                <span class="icon icon-grey"><i class="fas fa-hammer"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Total Upah Teknisi Bulan Ini</div>
                    <div class="dashboard-value">Rp <?php echo e(number_format($totalUpahTeknisi)); ?></div>
                    <small class="text-dark">
                        <i class="fas fa-wifi" style="color:#1565c0"></i> Pemasangan: Rp <?php echo e(number_format($upahPemasangan)); ?>

                        <span class="mx-1">|</span>
                        <i class="fas fa-tools" style="color:#fbc02d"></i> Mainten: Rp <?php echo e(number_format($upahMainten)); ?>

                    </small>
                </div>
            </a>
        </div>
    </div>
</div>

    <!-- TABLE PELANGGAN SUSPEND -->
    <div class="card mt-5">
        <div class="card-header bg-danger text-white">
            <i class="fas fa-user-slash"></i> List Pelanggan Suspend
            <input type="text" id="filterSuspend" class="form-control form-control-sm w-auto d-inline-block float-end" placeholder="Cari nama/alamat..." style="max-width:220px;">
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-dashboard table-hover mb-0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Nama</th>
                            <th>Alamat</th>
                            <th>Grub</th>
                            <th>No HP</th>
                            <th>Paket</th>
                            <th>Tgl Berlangganan</th>
                            <th>Status</th>
                            <!--<th>Foto Rumah</th>-->
                        </tr>
                    </thead>
                    <tbody id="suspendTableBody">
                        <?php $__empty_1 = true; $__currentLoopData = $pelangganSuspend; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><i class="fas fa-user-slash text-danger me-1"></i> <strong><?php echo e($p->nama); ?></strong></td>
                            <td><?php echo e($p->alamat); ?></td>
                            <td><?php echo e($p->nama_grub); ?></td>
                            <td><a href="https://wa.me/<?php echo e(preg_replace('/[^0-9]/','',$p->no_hp)); ?>" target="_blank" class="text-success"><i class="fab fa-whatsapp"></i> <?php echo e($p->no_hp); ?></a></td>
                            <td><?php echo e($p->paket_wifi); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($p->tanggal_berlangganan)->format('d M Y')); ?></td>
                            <td><span class="badge badge-suspend">Suspend</span></td>
                            <!--<td>
                                <?php if($p->foto_rumah): ?>
                                    <img src="<?php echo e(asset('storage/' . $p->foto_rumah)); ?>" class="foto-rumah" alt="Foto Rumah">
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>-->
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center text-danger">Tidak ada pelanggan suspend.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- Filter JS -->
<?php $__env->startSection('js'); ?>
<script>
document.getElementById('filterSuspend').addEventListener('keyup', function() {
    let filter = this.value.toLowerCase();
    let rows = document.querySelectorAll('#suspendTableBody tr');
    rows.forEach(function(row) {
        let nama = row.cells[1]?.innerText.toLowerCase();
        let alamat = row.cells[2]?.innerText.toLowerCase();
        row.style.display = (nama?.includes(filter) || alamat?.includes(filter)) ? '' : 'none';
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\billing_mgmt\resources\views/dashboard/admin.blade.php ENDPATH**/ ?>