

<?php $__env->startSection('title', 'Daftar Tagihan Pelanggan'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 class="mb-3">Daftar Tagihan Pelanggan</h2>
    <div class="row mb-3 align-items-center">
        <div class="col">
            <form method="GET" action="<?php echo e(route('pembayaran.index')); ?>" class="form-row justify-content-end">
                <div class="col-12 col-md-auto mb-2 mb-md-0">
                    <input type="text" name="q" id="inputCariPelanggan" class="form-control" placeholder="Cari Nama atau ID" value="<?php echo e(request('q')); ?>">
                </div>
                <div class="col-12 col-md-auto mb-2 mb-md-0">
                    <select name="grub_id" class="form-control">
                        <option value="">-- Semua Grub --</option>
                        <?php $__currentLoopData = $grubs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($grub->id); ?>" <?php echo e(request('grub_id') == $grub->id ? 'selected' : ''); ?>>
                                <?php echo e($grub->nama_grub); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-12 col-md-auto mb-2 mb-md-0">
                    <!-- Tombol Scan Barcode -->
                    <button type="button" class="btn btn-info" data-toggle="modal" data-target="#modalScanBarcode">
                        <i class="fas fa-barcode"></i> Scan Barcode
                    </button>
                </div>
                <div class="col-12 col-md-auto">
                    <button type="submit" class="btn btn-primary mr-1">Filter</button>
                    <a href="<?php echo e(route('pembayaran.index')); ?>" class="btn btn-secondary">Reset</a>
                </div>
            </form>
        </div>
    </div>
    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <div class="card shadow-sm">
        <div class="card-body p-2">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped table-sm mb-0 align-middle">
                    <thead class="bg-gradient-primary text-white text-center">
                        <tr>
                            <th style="width:40px;">No</th>
                            <th>Pelanggan</th>
                            <th>Grub</th>
                            <th>Bulan</th>
                            <th>Tanggal Tagihan</th>
                            <th class="text-right">Tagihan (Rp)</th>
                            <th class="text-right">Pembayaran (Rp)</th>
                            <th>Status</th>
                            <th style="width:70px;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $pembayarans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pembayaran): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $periode = $pembayaran->periode;
                            $tgl_berlangganan = $pembayaran->pelanggan->tanggal_berlangganan ?? null;
                            $day = $tgl_berlangganan ? \Carbon\Carbon::parse($tgl_berlangganan)->day : 1;
                            $tanggal_tagihan = $periode ? \Carbon\Carbon::createFromFormat('Y-m', $periode)->day($day) : null;
                        ?>
                        <tr>
                            <td><?php echo e($loop->iteration + ($pembayarans->currentPage()-1)*$pembayarans->perPage()); ?></td>
                            <td style="min-width:110px">
                                <?php echo e($pembayaran->pelanggan->nama ?? '-'); ?>

                                <?php if($pembayaran->pelanggan->status == 'suspend'): ?>
                                    <span class="badge badge-danger ml-1">Suspend</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($pembayaran->pelanggan->grub->nama_grub ?? '-'); ?></td>
                            <td><?php echo e($periode ? \Carbon\Carbon::createFromFormat('Y-m', $periode)->translatedFormat('F Y') : '-'); ?></td>
                            <td><?php echo e($tanggal_tagihan ? $tanggal_tagihan->format('d-m-Y') : '-'); ?></td>
                            <td class="text-right"><?php echo e(number_format($pembayaran->jumlah_tagihan, 0, ',', '.')); ?></td>
                            <td class="text-right"><?php echo e(number_format($pembayaran->jumlah_dibayar, 0, ',', '.')); ?></td>
                            <td>
                                <?php if($pembayaran->jumlah_dibayar >= $pembayaran->jumlah_tagihan): ?>
                                    <span class="badge badge-success w-100">Lunas</span>
                                <?php else: ?>
                                    <span class="badge badge-warning text-dark w-100">Belum Lunas</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($pembayaran->jumlah_dibayar < $pembayaran->jumlah_tagihan): ?>
                                    <button class="btn btn-success btn-sm w-100"
                                            data-toggle="modal"
                                            data-target="#modalBayar<?php echo e($pembayaran->id); ?>">
                                        Bayar
                                    </button>
                                <?php else: ?>
                                    <span class="btn btn-secondary btn-sm w-100" disabled>Sudah Dibayar</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if($pembayarans->count() == 0): ?>
                        <tr>
                            <td colspan="9" class="text-center">Tidak ada data pembayaran</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-2 mb-0">
                <?php echo e($pembayarans->appends(request()->input())->links()); ?>

            </div>
        </div>
    </div>
</div>

</div>

<!-- MODAL SCAN BARCODE -->
<div class="modal fade" id="modalScanBarcode" tabindex="-1" role="dialog" aria-labelledby="modalScanBarcodeLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalScanBarcodeLabel">Scan Barcode / QR Code Pelanggan</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div id="reader" style="width:100%"></div>
        <div id="scan-result" class="mt-3"></div>
      </div>
    </div>
  </div>
</div>

<!-- MODAL PEMBAYARAN -->



<style>
@media (max-width: 600px) {
    .table th, .table td { font-size: 13px !important; padding: 6px 4px !important;}
    .table th { white-space: nowrap; }
    .table td { vertical-align: middle;}
    .badge, .btn { font-size: 12px !important; padding: 4px 8px !important;}
    .form-control, .btn { font-size: 13px !important;}
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<!-- html5-qrcode CDN -->
<script src="https://unpkg.com/html5-qrcode"></script>
<script>
let scannerBarcode;
let scanningBarcode = false;

$('#modalScanBarcode').on('shown.bs.modal', function () {
    if (!scanningBarcode) {
        scannerBarcode = new Html5Qrcode("reader");
        scanningBarcode = true;
        scannerBarcode.start(
            { facingMode: "environment" },
            { fps: 10, qrbox: 250 },
            (decodedText, decodedResult) => {
                // Format: XXXX-<id>
                var parts = decodedText.split('-');
                if(parts.length === 2) {
                    var pelangganId = parts[1].trim();
                    $('#scan-result').html(
                        `<div class="alert alert-success">
                            Barcode ditemukan: <b>${decodedText}</b><br>
                            ID Pelanggan: <b>${pelangganId}</b><br>
                            <button class="btn btn-primary mt-2" onclick="cariPelangganById('${pelangganId}')">Cari Tagihan</button>
                        </div>`
                    );
                    scannerBarcode.stop();
                    scanningBarcode = false;
                } else {
                    $('#scan-result').html('<div class="alert alert-danger">Barcode tidak valid! Format harus XXXX-<id></div>');
                }
            },
            (errorMessage) => {}
        );
    }
});
$('#modalScanBarcode').on('hidden.bs.modal', function () {
    if (scanningBarcode && scannerBarcode) {
        scannerBarcode.stop();
        scanningBarcode = false;
        $('#scan-result').html('');
    }
});
function cariPelangganById(id) {
    // Isi input pencarian dan submit form
    $('#inputCariPelanggan').val(id);
    $('form[action="<?php echo e(route('pembayaran.index')); ?>"]').submit();
    $('#modalScanBarcode').modal('hide');
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\billing_mgmt\resources\views/pembayaran/index.blade.php ENDPATH**/ ?>