

<?php $__env->startSection('title', 'Manajemen Site / Pusat Koneksi'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 class="mb-3">Daftar Site / Pusat Koneksi</h2>
    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="card shadow">
        <div class="card-body p-2">
            <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#modalTambahSite">
                Tambah Site
            </button>
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped table-sm mb-0 align-middle">
                    <thead class="bg-gradient-primary text-white">
                        <tr>
                            <th>No</th>
                            <th>Nama Site</th>
                            <th>Lokasi Site</th>
                            <th>Keterangan</th>
                            <th>Dibuat</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $sites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $site): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration + ($sites->currentPage()-1)*$sites->perPage()); ?></td>
                            <td><?php echo e($site->nama_site); ?></td>
                            <td><?php echo e($site->lokasi_site); ?></td>
                            <td><?php echo e($site->keterangan); ?></td>
                            <td><?php echo e($site->created_at->format('d-m-Y H:i')); ?></td>
                            <td>
                                <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#modalEditSite<?php echo e($site->id); ?>">Edit</button>
                                <form action="<?php echo e(route('sites.destroy', $site->id)); ?>" method="POST" style="display:inline;">
                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Yakin hapus site ini?')">Hapus</button>
                                </form>
                            </td>
                        </tr>
                        <!-- Modal Edit Site -->
                        <div class="modal fade" id="modalEditSite<?php echo e($site->id); ?>" tabindex="-1">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <form action="<?php echo e(route('sites.update', $site->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
                                        <div class="modal-header">
                                            <h5 class="modal-title">Edit Site</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="mb-3">
                                                <label>Nama Site</label>
                                                <input type="text" name="nama_site" class="form-control" value="<?php echo e($site->nama_site); ?>" required>
                                            </div>
                                            <div class="mb-3">
                                                <label>Lokasi Site</label>
                                                <input type="text" name="lokasi_site" class="form-control" value="<?php echo e($site->lokasi_site); ?>">
                                            </div>
                                            <div class="mb-3">
                                                <label>Keterangan</label>
                                                <textarea name="keterangan" class="form-control"><?php echo e($site->keterangan); ?></textarea>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-success">Update</button>
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if($sites->count() == 0): ?>
                        <tr>
                            <td colspan="6" class="text-center">Tidak ada data site</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-2">
                <?php echo e($sites->appends(request()->input())->links()); ?>

            </div>
        </div>
    </div>
</div>

<!-- Modal Tambah Site -->
<div class="modal fade" id="modalTambahSite" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo e(route('sites.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Site</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label>Nama Site</label>
                        <input type="text" name="nama_site" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Lokasi Site</label>
                        <input type="text" name="lokasi_site" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label>Keterangan</label>
                        <textarea name="keterangan" class="form-control"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\billing_mgmt\resources\views/site/index.blade.php ENDPATH**/ ?>