

<?php $__env->startSection('title', 'Daftar Paket Internet'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1 class="mb-2">Daftar Paket Internet</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="mb-2 d-flex justify-content-start">
        <a href="<?php echo e(route('paket_internet.create')); ?>" class="btn btn-primary btn-sm">
            <i class="fas fa-plus"></i> Tambah Paket
        </a>
    </div>
    <div class="card shadow">
        <div class="card-header bg-primary text-white">
            <span><i class="fas fa-wifi"></i> Paket Internet</span>
        </div>
        <div class="card-body p-2">
            <?php if(session('success')): ?>
                <div class="alert alert-success"><?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <div class="table-responsive">
                <?php
                function sort_link_paket($field, $label, $sort, $direction) {
                    $params = request()->except('page');
                    $params['sort'] = $field;
                    $params['direction'] = ($sort == $field && $direction == 'asc') ? 'desc' : 'asc';
                    $icon = '';
                    if ($sort == $field) {
                        $icon = $direction == 'asc' ? '↑' : '↓';
                    }
                    $url = url()->current() . '?' . http_build_query($params);
                    return '<a href="'.$url.'" style="color:inherit;text-decoration:none;">' . $label . ' ' . $icon . '</a>';
                }
                ?>
                <table class="table table-bordered table-striped table-hover table-sm align-middle mb-0">
                    <thead class="bg-gradient-primary text-white">
                        <tr>
                            <th width="50">No</th>
                            <th><?php echo sort_link_paket('nama_paket', 'Nama Paket', $sort ?? '', $direction ?? ''); ?></th>
                            <th><?php echo sort_link_paket('harga', 'Harga', $sort ?? '', $direction ?? ''); ?></th>
                            <th width="120">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $pakets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($loop->iteration + ($pakets->currentPage()-1)*$pakets->perPage()); ?></td>
                            <td><?php echo e($paket->nama_paket); ?></td>
                            <td>
                                <span class="badge bg-info text-dark">Rp<?php echo e(number_format($paket->harga,0,',','.')); ?></span>
                            </td>
                            <td>
                                <a href="<?php echo e(route('paket_internet.edit', $paket->id)); ?>" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i></a>
                                <form action="<?php echo e(route('paket_internet.destroy', $paket->id)); ?>" method="POST" style="display:inline;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button onclick="return confirm('Yakin hapus?')" class="btn btn-danger btn-sm"><i class="fas fa-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="text-center">Tidak ada data paket internet</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <br>
            nb : klik header tabel untuk sort.
            <div class="mt-2">
                <?php echo e($pakets->links()); ?>

            </div>
            
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\billing_mgmt\resources\views/paket_internet/index.blade.php ENDPATH**/ ?>