<?php
    function showPembayaranFields($jenis_tugas) {
        return in_array($jenis_tugas, ['mainten pelanggan', 'pemasangan baru']);
    }
?>


<?php $__env->startSection('title', 'Jadwal Tugas Saya'); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 class="mb-3">Jadwal Tugas Saya</h2>
    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <!-- ... filter form ... -->

    <div class="card shadow">
        <div class="card-body p-2">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped mb-0 align-middle">
                    <thead class="bg-gradient-primary text-white">
                        <tr>
                            <th>No</th>
                            <th>No Tiket</th>
                            <th>Tanggal</th>
                            <th>Lokasi/Nama Pelanggan</th>
                            <th>Deskripsi Tugas</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $jadwals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jadwal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $jadwal_teknisi_user = $jadwal->jadwalTeknisiUsers->where('teknisi_id', auth()->id())->first();
                            $pelanggan = $jadwal->pelanggan; // relasi pelanggan pada jadwal
                        ?>
                        <tr>
                            <td><?php echo e($loop->iteration + ($jadwals->currentPage()-1)*$jadwals->perPage()); ?></td>
                            <td><?php echo e($jadwal->no_tiket); ?></td>
                            <td><?php echo e($jadwal->tanggal); ?></td>
                            <td>
                                <?php if($pelanggan): ?>
                                    <a href="#" data-bs-toggle="modal" data-bs-target="#modalDetailTeknis<?php echo e($pelanggan->id); ?>" style="font-weight:bold; color:#0d6efd;">
                                        <?php echo e($pelanggan->nama); ?>

                                    </a>
                                <?php else: ?>
                                    <?php echo e($jadwal->lokasi ?: '-'); ?>

                                <?php endif; ?>
                            </td>
                            <td><?php echo e($jadwal->deskripsi_tugas); ?></td>
                            <?php
                                $all_teknisi_users = $jadwal->jadwalTeknisiUsers;
                                $pending_teknisi = $all_teknisi_users
                                    ->where('status_feedback', '!=', 'selesai')
                                    ->where('teknisi_id', '!=', auth()->id())
                                    ->pluck('teknisi.name')
                                    ->toArray();
                            ?>

                            <td>
                                <?php if($jadwal_teknisi_user->status_feedback == 'selesai' && $jadwal_teknisi_user->status_validasi == 'validated'): ?>
                                    <span class="badge bg-success">Selesai & Validated</span>
                                    <?php if(count($pending_teknisi)): ?>
                                        <br>
                                        <span class="badge bg-secondary">Menunggu <?php echo e(implode(', ', $pending_teknisi)); ?></span>
                                    <?php endif; ?>
                                <?php elseif($jadwal_teknisi_user->status_feedback == 'selesai'): ?>
                                    <span class="badge bg-warning">
                                        Selesai & Belum Validasi
                                    </span>
                                    <?php if(count($pending_teknisi)): ?>
                                        <br>
                                        <span class="badge bg-secondary">Menunggu <?php echo e(implode(', ', $pending_teknisi)); ?></span>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="badge bg-danger text-dark">Open</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="d-flex gap-1">
                                    <?php if($jadwal_teknisi_user && $jadwal_teknisi_user->status_feedback != 'selesai'): ?>
                                        <button type="button" 
                                            class="btn btn-info btn-xs" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#feedbackModal<?php echo e($jadwal_teknisi_user->id); ?>">
                                            Feedback
                                        </button>
                                    <?php else: ?>
                                        <span class="badge bg-success">Sudah Feedback</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>

                        <!-- Modal Detail Teknis Pelanggan -->
<!-- Modal Detail Teknis Pelanggan -->
<?php if($pelanggan): ?>
<div class="modal fade" id="modalDetailTeknis<?php echo e($pelanggan->id); ?>" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Detail Teknis Pelanggan : <?php echo e($pelanggan->nama); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <ul class="list-group">
        <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>Status Berlangganan  :</strong>
                  <span id="ip<?php echo e($pelanggan->id); ?>">            
                      <?php if($pelanggan->status == 'suspend'): ?>
                        <span class="badge badge-danger">Suspend</span>
                      <?php else: ?>
                        <span class="badge badge-success">Aktif</span>
                      <?php endif; ?></span>
                </div>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>IP Address :</strong>
                  <span id="ip<?php echo e($pelanggan->id); ?>"><?php echo e($pelanggan->ip_address ?? '-'); ?></span>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('ip<?php echo e($pelanggan->id); ?>')" title="Copy IP">
                  <i class="fas fa-copy"></i>
                </button>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>PPPoE User/pass :</strong>
                  <span id="pppoe<?php echo e($pelanggan->id); ?>"><?php echo e($pelanggan->pppoe_username ?? '-'); ?></span>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('pppoe<?php echo e($pelanggan->id); ?>')" title="Copy PPPoE">
                  <i class="fas fa-copy"></i>
                </button>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>Alamat :</strong>
                  <span id="pppoe<?php echo e($pelanggan->id); ?>"><?php echo e($pelanggan->alamat ?? '-'); ?></span>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('pppoe<?php echo e($pelanggan->id); ?>')" title="Copy PPPoE">
                  <i class="fas fa-copy"></i>
                </button>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
            <div>
                  <strong>Kontak 1 :</strong>
                  <?php if($pelanggan->no_hp): ?>
                    <?php
                        $wa = preg_replace('/[^0-9]/','',$pelanggan->no_hp);
                    ?>
                    <a href="https://wa.me/<?php echo e($wa); ?>" target="_blank" class="text-success" id="kontak1<?php echo e($pelanggan->id); ?>">
                        <i class="fab fa-whatsapp"></i> <?php echo e($pelanggan->no_hp); ?>

                    </a>
                  <?php else: ?>
                    <span id="kontak1<?php echo e($pelanggan->id); ?>">-</span>
                  <?php endif; ?>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('kontak1<?php echo e($pelanggan->id); ?>')" title="Copy Kontak 1">
                  <i class="fas fa-copy"></i>
                </button>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
            <div>
                  <strong>Kontak 1 :</strong>
                  <?php if($pelanggan->no_hp): ?>
                    <?php
                        $wa = preg_replace('/[^0-9]/','',$pelanggan->no_hp2);
                    ?>
                    <a href="https://wa.me/<?php echo e($wa); ?>" target="_blank" class="text-success" id="kontak1<?php echo e($pelanggan->id); ?>">
                        <i class="fab fa-whatsapp"></i> <?php echo e($pelanggan->no_hp2); ?>

                    </a>
                  <?php else: ?>
                    <span id="kontak1<?php echo e($pelanggan->id); ?>">-</span>
                  <?php endif; ?>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('kontak1<?php echo e($pelanggan->id); ?>')" title="Copy Kontak 1">
                  <i class="fas fa-copy"></i>
                </button>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>Keterangan :</strong>
                  <span id="pppoe<?php echo e($pelanggan->id); ?>"><?php echo e($pelanggan->keterangan ?? '-'); ?></span>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('pppoe<?php echo e($pelanggan->id); ?>')" title="Copy PPPoE">
                  <i class="fas fa-copy"></i>
                </button>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>Koordinat Lokasi :</strong>
                  <span id="koordinat<?php echo e($pelanggan->id); ?>"><?php echo e($pelanggan->koordinat_lokasi ?? '-'); ?></span>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('koordinat<?php echo e($pelanggan->id); ?>')" title="Copy Koordinat">
                  <i class="fas fa-copy"></i>
                </button>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>Maps lokasi :</strong>
                  <span id="pppoe<?php echo e($pelanggan->id); ?>"><?php echo e($pelanggan->google_maps_link ?? '-'); ?></span>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('pppoe<?php echo e($pelanggan->id); ?>')" title="Copy PPPoE">
                  <i class="fas fa-copy"></i>
                </button>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>Site / Pusat Koneksi :</strong>
                  <span id="site<?php echo e($pelanggan->id); ?>">
                    <?php echo e($pelanggan->site->nama_site ?? '-'); ?>

                    <?php if($pelanggan->site && $pelanggan->site->lokasi_site): ?>
                        <br><small class="text-muted"><?php echo e($pelanggan->site->lokasi_site); ?></small>
                    <?php endif; ?>
                  </span>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('site<?php echo e($pelanggan->id); ?>')" title="Copy Site">
                  <i class="fas fa-copy"></i>
                </button>
            </li>
            <li class="list-group-item">
                            <strong>Foto Rumah :</strong>
                                <?php if($pelanggan->foto_rumah): ?>
                                <br>
                                    <img src="<?php echo e(asset('storage/' . $pelanggan->foto_rumah)); ?>" alt="Foto Rumah" class="img-thumbnail" style="max-width:250px;">
                                <?php else: ?>
                                -
                                <?php endif; ?>
                        </li>
        </ul>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
      </div>
    </div>
  </div>
</div>
<?php endif; ?>

<!-- Toast Copy Notification -->
<div class="position-fixed bottom-0 end-0 p-3" style="z-index: 9999">
  <div id="toastCopySuccess" class="toast align-items-center text-bg-success border-0" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="d-flex">
      <div class="toast-body">
        Berhasil dicopy ke clipboard!
      </div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
  </div>
</div>

                        <!-- Modal Feedback -->
                        <?php if($jadwal_teknisi_user && $jadwal_teknisi_user->status_feedback != 'selesai'): ?>
                        <div class="modal fade" id="feedbackModal<?php echo e($jadwal_teknisi_user->id); ?>" tabindex="-1" aria-labelledby="feedbackModalLabel<?php echo e($jadwal_teknisi_user->id); ?>" aria-hidden="true">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <form method="POST" 
                                  action="<?php echo e(route('jadwal-saya.feedback.submit', [$jadwal->id, $jadwal_teknisi_user->id])); ?>" 
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="modal-header">
                                  <h5 class="modal-title" id="feedbackModalLabel<?php echo e($jadwal_teknisi_user->id); ?>">Feedback Tugas Teknisi</h5>
                                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                  <div class="mb-3">
                                    <label>Keterangan Feedback</label>
                                    <textarea name="feedback_text" class="form-control" required><?php echo e(old('feedback_text', $jadwal_teknisi_user->feedback_text)); ?></textarea>
                                  </div>
                                  
<div class="mb-3">
  <label>Foto (opsional, max 250KB)</label>
  <input type="file" name="feedback_photo" accept="image/*" class="form-control feedback-photo-input" data-max="256000" data-jadwal-id="<?php echo e($jadwal_teknisi_user->id); ?>">
  <?php if($jadwal_teknisi_user->feedback_photo): ?>
      <img src="<?php echo e(asset('storage/'.$jadwal_teknisi_user->feedback_photo)); ?>" alt="Foto Feedback" class="img-fluid mt-2" style="max-width:200px;">
  <?php endif; ?>
  <div class="invalid-feedback d-none" id="feedbackPhotoError<?php echo e($jadwal_teknisi_user->id); ?>">
      Ukuran foto maksimal 250KB!
  </div>
</div>
                                  <?php if(showPembayaranFields($jadwal->jenis_tugas)): ?>
                                  <div class="mb-3">
                                    <label>Nominal Bayar (opsional)</label>
                                    <input type="number" min="0" name="nominal_bayar" id="nominal_bayar_<?php echo e($jadwal_teknisi_user->id); ?>" class="form-control" value="<?php echo e(old('nominal_bayar', $jadwal_teknisi_user->nominal_bayar)); ?>">
                                  </div>
                                  <div class="mb-3">
                                    <label>Metode Bayar</label>
                                    <select name="metode_bayar" id="metode_bayar_<?php echo e($jadwal_teknisi_user->id); ?>" class="form-control" disabled>
                                        <option value="">-- Pilih Metode --</option>
                                        <option value="cash" <?php echo e(old('metode_bayar', $jadwal_teknisi_user->metode_bayar)=='cash' ? 'selected' : ''); ?>>Cash</option>
                                        <option value="transfer" <?php echo e(old('metode_bayar', $jadwal_teknisi_user->metode_bayar)=='transfer' ? 'selected' : ''); ?>>Transfer</option>
                                    </select>
                                  </div>
                                  <script>
                                  document.addEventListener('DOMContentLoaded', function() {
                                    var nominalInput = document.getElementById('nominal_bayar_<?php echo e($jadwal_teknisi_user->id); ?>');
                                    var metodeSelect = document.getElementById('metode_bayar_<?php echo e($jadwal_teknisi_user->id); ?>');
                                    if(nominalInput && metodeSelect){
                                        nominalInput.addEventListener('input', function(){
                                            metodeSelect.disabled = !(nominalInput.value && parseInt(nominalInput.value) > 0);
                                        });
                                        // Aktifkan jika sudah ada nilai (edit feedback)
                                        metodeSelect.disabled = !(nominalInput.value && parseInt(nominalInput.value) > 0);
                                    }
                                  });
                                  </script>
                                  <?php endif; ?>
                                </div>
                                <div class="modal-footer">
                                  <button type="submit" class="btn btn-success">Kirim Feedback</button>
                                  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if($jadwals->count() == 0): ?>
                        <tr>
                            <td colspan="7" class="text-center">Tidak ada jadwal tugas</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-2 mb-0">
                <?php echo e($jadwals->appends(request()->input())->links()); ?>

            </div>
            Nb : klik setiap nama untuk tampilkan detail pelanggan.
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<!-- Font Awesome -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/js/all.min.js"></script>
<script>
function copyToClipboard(elementId) {
    var el = document.getElementById(elementId);
    var text = el ? el.innerText : '';
    // Try Clipboard API
    if (navigator.clipboard && window.isSecureContext) {
        navigator.clipboard.writeText(text).then(function() {
            showCopyToast();
        }, function(err) {
            fallbackCopyText(text);
        });
    } else {
        fallbackCopyText(text);
    }
}
function fallbackCopyText(text) {
    // Create a temporary input/textarea for copy
    var tempInput = document.createElement('textarea');
    tempInput.value = text;
    tempInput.setAttribute('readonly', '');
    tempInput.style.position = 'absolute';
    tempInput.style.left = '-9999px';
    document.body.appendChild(tempInput);
    tempInput.select();
    document.execCommand('copy');
    document.body.removeChild(tempInput);
    showCopyToast();
}
function showCopyToast() {
    var toastEl = document.getElementById('toastCopySuccess');
    if (toastEl) {
        var toast = new bootstrap.Toast(toastEl);
        toast.show();
    }
}

document.addEventListener('DOMContentLoaded', function() {
  document.querySelectorAll('.feedback-photo-input').forEach(function(input) {
    input.addEventListener('change', function(e) {
      const maxSize = parseInt(input.getAttribute('data-max')) || 256000;
      const file = input.files[0];
      const jadwalId = input.getAttribute('data-jadwal-id');
      const errorDiv = document.getElementById('feedbackPhotoError' + jadwalId);

      if (file && file.size > maxSize) {
        input.value = ''; // kosongkan input
        // Tampilkan pesan error
        if(errorDiv){
          errorDiv.classList.remove('d-none');
        }
        // Optional: alert popup
        alert('Ukuran foto terlalu besar! Maksimal 250KB.');
      } else {
        if(errorDiv){
          errorDiv.classList.add('d-none');
        }
      }
    });
  });
});
</script>
<!-- Bootstrap JS untuk modal -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\billing_mgmt\resources\views/jadwal_teknisi/jadwal_saya.blade.php ENDPATH**/ ?>