<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PelangganController;
use App\Http\Controllers\PembayaranController;
use App\Http\Controllers\JadwalTeknisiController;
use App\Http\Controllers\GrubController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\PenagihanController;
use App\Http\Controllers\PaketInternetController;
use App\Http\Controllers\RekapPembayaranController;
use App\Http\Controllers\RekapKasController;
use App\Http\Controllers\RekapUpahController;
use App\Http\Controllers\QrController;
use App\Http\Controllers\AdminDashboardController;
use App\Http\Controllers\TeknisiDashboardController;
use App\Http\Controllers\PenagihanDashboardController;
use App\Http\Controllers\StokOpnameController;
use App\Http\Controllers\NetworkMapController;

// Rute untuk role 'penagihan'
Route::middleware(['role:penagihan'])->group(function() {
    Route::get('pembayaran', [PenagihanController::class, 'index'])->name('pembayaran.index');
    Route::post('pembayaran/bayar/{id}', [PenagihanController::class, 'bayarSubmit'])->name('pembayaran.bayar.submit');
    Route::post('pembayaran/{id}/validasi', [PenagihanController::class, 'validasi']);
});

// --- Rute khusus untuk role 'admin' ---
Route::middleware(['role:admin'])->group(function() {
    // CRUD pelanggan
    Route::get('/qr/print', [QrController::class, 'print'])->name('qr.print');
    Route::resource('pelanggan', PelangganController::class);
    Route::resource('grubs', GrubController::class);
    Route::resource('sites', \App\Http\Controllers\SiteController::class)->except(['show']);
    Route::get('list-pelanggan', [\App\Http\Controllers\ListPelangganController::class, 'index'])->name('list-pelanggan.index');

    // suspen pelanggan
    Route::post('/pelanggan/{id}/suspend', [PelangganController::class, 'suspend'])->name('pelanggan.suspend');
    Route::post('/pelanggan/{id}/aktifkan', [PelangganController::class, 'aktifkan'])->name('pelanggan.aktifkan');

    // Cek semua tagihan pelanggan tertentu
    Route::get('pelanggan/{pelanggan}/tagihan', [PelangganController::class, 'tagihan'])->name('pelanggan.tagihan');

    // Cek tagihan pelanggan yang belum lunas
    Route::get('pelanggan/{pelanggan}/tagihan-belum-lunas', [PelangganController::class, 'tagihanBelumLunas'])->name('pelanggan.tagihan_belum_lunas');

    //rekap pembayaran
    Route::get('/rekap-pembayaran', [RekapPembayaranController::class, 'index'])->name('rekap_pembayaran.index');
    Route::get('/rekap-kas', [RekapKasController::class, 'index'])->name('rekap_kas.index');
    Route::get('/rekap-upah', [RekapUpahController::class, 'index'])->name('rekap_upah.index');

    //paket wipi
    Route::resource('paket_internet', PaketInternetController::class);

    // Jadwal teknisi & pembayaran (admin)
    // Untuk validasi & input upah admin
    Route::post('jadwal-teknisi-user/{id}/validasi', [JadwalTeknisiController::class, 'validasiUpah'])->name('jadwal-teknisi-user.validasi');
    // Untuk buka kembali tugas (ubah status teknisi ke open)
    Route::post('jadwal-teknisi-user/{id}/open', [JadwalTeknisiController::class, 'openFeedback'])->name('jadwal-teknisi-user.open');
    Route::post('jadwal-teknisi-user/{id}/upah', [JadwalTeknisiController::class, 'inputUpah'])->name('jadwal-teknisi-user.upah');
    Route::get('jadwal-teknisi/generate-tiket', [JadwalTeknisiController::class, 'generateTiket'])->name('jadwal-teknisi.generate-tiket');
    Route::get('jadwal-teknisi/autocomplete-teknisi', [JadwalTeknisiController::class, 'autocompleteTeknisi'])->name('jadwal-teknisi.autocomplete-teknisi');
    Route::get('jadwal-teknisi/autocomplete-lokasi', [JadwalTeknisiController::class, 'autocompleteLokasi'])->name('jadwal-teknisi.autocomplete-lokasi');
    Route::resource('jadwal-teknisi', JadwalTeknisiController::class);

    // Resource pembayaran untuk admin (kecuali index & show)
    // Gunakan rute yang berbeda untuk bayar admin
    Route::post('pembayaran/bayar-admin/{id}', [PembayaranController::class, 'bayar'])->name('pembayaran.bayar.admin');
    Route::post('/pembayaran/{id}/cicil', [PembayaranController::class, 'bayarCicilan'])->name('pembayaran.cicil');
    Route::resource('pembayaran', PembayaranController::class)->except(['index', 'show']);
    Route::get('pembayaran/generate-tagihan', [PembayaranController::class, 'generateTagihan'])->name('pembayaran.generate_tagihan');

    // USER MANAGEMENT (fitur tambah, list, edit, hapus user)
    Route::get('users', [UserController::class, 'index'])->name('users.index');
    Route::get('users/{id}/edit', [UserController::class, 'edit'])->name('users.edit');
    Route::put('users/{id}', [UserController::class, 'update'])->name('users.update');
    Route::delete('users/{id}', [UserController::class, 'destroy'])->name('users.destroy');

    // REGISTER USER (khusus admin)
    Route::get('register', [RegisteredUserController::class, 'create'])->name('register.create');
    Route::post('register', [RegisteredUserController::class, 'store'])->name('register.store');
});

// --- Rute untuk role 'teknisi' ---
Route::middleware(['role:teknisi'])->group(function() {
    Route::get('jadwal-saya', [JadwalTeknisiController::class, 'jadwalSaya'])->name('jadwal-saya');
    Route::get('jadwal-saya', [JadwalTeknisiController::class, 'jadwalSaya'])->name('jadwal-saya');
    // Form feedback teknisi (per tugas & per teknisi)
    Route::get('jadwal-saya/{jadwal}/feedback/{jadwalTeknisiUser}', [JadwalTeknisiController::class, 'feedbackForm'])->name('jadwal-saya.feedback.form');
    Route::post('jadwal-saya/{jadwal}/feedback/{jadwalTeknisiUser}', [JadwalTeknisiController::class, 'feedbackSubmit'])->name('jadwal-saya.feedback.submit');
});

// --- Rute untuk role 'admin' atau 'teknisi' (gabungan) ---
Route::middleware(['role:admin|teknisi'])->group(function() {
    Route::post('jadwal-teknisi/{id}/feedback', [JadwalTeknisiController::class, 'feedback'])->name('jadwal-teknisi.feedback');
});

// --- Route default dan profile ---
Route::get('/', function () {
    return redirect('/login');
});

// Dashboard untuk semua user, redirect ke dashboard sesuai role
Route::get('/dashboard', function () {
    $user = auth()->user();
    if ($user->hasRole('admin')) {
        return redirect()->route('dashboard.admin');
    } elseif ($user->hasRole('teknisi')) {
        return redirect()->route('dashboard.teknisi');
    } elseif ($user->hasRole('penagihan')) {
        return redirect()->route('dashboard.penagihan');
    }
    return abort(403, 'Role tidak dikenali');
})->middleware(['auth', 'verified'])->name('dashboard');

// Dashboard per role
Route::middleware(['auth', 'role:admin'])->get('/dashboard/admin', [AdminDashboardController::class, 'index'])->name('dashboard.admin');
Route::middleware(['auth', 'role:teknisi'])->get('/dashboard/teknisi', [TeknisiDashboardController::class, 'index'])->name('dashboard.teknisi');
Route::middleware(['auth', 'role:penagihan'])->get('/dashboard/penagihan', [PenagihanDashboardController::class, 'index'])->name('dashboard.penagihan');

//STOK OPNAM ALAT
// --- Rute Stok Opname Alat ---
// CRUD untuk admin & teknisi-opname
/*Route::middleware(['auth', 'role:teknisi-opname'])->group(function() {
    Route::get('stok-opname', [StokOpnameController::class, 'index'])->name('stok-opname.index');
    Route::post('stok-opname', [StokOpnameController::class, 'store'])->name('stok-opname.store');
    Route::put('stok-opname/{id}', [StokOpnameController::class, 'update'])->name('stok-opname.update');
    Route::delete('stok-opname/{id}', [StokOpnameController::class, 'destroy'])->name('stok-opname.destroy');
});
// View-only untuk teknisi
Route::middleware(['auth', 'role:teknisi'])->group(function() {
    Route::get('stok-opname', [StokOpnameController::class, 'index'])->name('stok-opname.index');
});
*/
//stok opname v2
Route::middleware(['auth', 'role:teknisi-opname|teknisi'])->group(function() {
    //nunut kene wae peta jaringane
    Route::get('/network-map', [NetworkMapController::class, 'index'])->name('network-map');
    // Rute GET untuk halaman index, bisa diakses oleh teknisi-opname dan teknisi
    Route::get('stok-opname', [StokOpnameController::class, 'index'])->name('stok-opname.index');
    
    // Rute-rute ini hanya untuk teknisi-opname
    Route::post('stok-opname', [StokOpnameController::class, 'store'])->name('stok-opname.store')->middleware('role:teknisi-opname');
    Route::put('stok-opname/{id}', [StokOpnameController::class, 'update'])->name('stok-opname.update')->middleware('role:teknisi-opname');
    Route::delete('stok-opname/{id}', [StokOpnameController::class, 'destroy'])->name('stok-opname.destroy')->middleware('role:teknisi-opname');
});


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';