@extends('adminlte::page')
@section('title', 'Edit User')

@section('content')
<div class="container">
    <div class="card mt-4">
        <div class="card-header bg-warning">
            <h4>Edit User</h4>
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <form action="{{ route('users.update', $user->id) }}" method="POST">
                @csrf @method('PUT')
                <div class="mb-3">
                    <label>Nama</label>
                    <input type="text" name="name" class="form-control" required value="{{ old('name', $user->name) }}">
                </div>
                <div class="mb-3">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" required value="{{ old('email', $user->email) }}">
                </div>
                <div class="mb-3">
                    <label>Role</label>
                    <div>
                        @foreach($roles as $role)
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="checkbox" name="role[]" value="{{ $role->name }}"
                                    id="role_{{ $role->name }}"
                                    {{ $user->roles->pluck('name')->contains($role->name) ? 'checked' : '' }}>
                                <label class="form-check-label" for="role_{{ $role->name }}">
                                    {{ ucfirst($role->name) }}
                                </label>
                            </div>
                        @endforeach
                    </div>
                    <small class="text-muted">Pilih satu atau lebih role sesuai kebutuhan.</small>
                </div>
                <div class="mb-3">
                    <label>Password (Kosongkan jika tidak ganti)</label>
                    <input type="password" name="password" class="form-control">
                </div>
                <div class="mb-3">
                    <label>Konfirmasi Password</label>
                    <input type="password" name="password_confirmation" class="form-control">
                </div>
                <button type="submit" class="btn btn-success">Update</button>
                <a href="{{ route('users.index') }}" class="btn btn-secondary">Kembali</a>
            </form>
        </div>
    </div>
</div>
@endsection