@extends('adminlte::page')
@section('title', 'Stok Opname Alat')

@section('content')
<div class="container">
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="mb-3 d-flex justify-content-between">
        @if($canCrud)
            <button class="btn btn-success btn-sm" data-toggle="modal" data-target="#modalTambah">+ Tambah Alat</button>
        @endif
        <!-- Filter Form -->
        <form method="GET" class="form-inline" action="{{ route('stok-opname.index') }}">
            <input type="text" name="q" class="form-control form-control-sm mr-2" placeholder="Nama/Serial" value="{{ request('q') }}">
            <input type="date" name="tanggal_masuk" class="form-control form-control-sm mr-2" placeholder="Tgl Masuk" value="{{ request('tanggal_masuk') }}">
            <input type="date" name="tanggal_keluar" class="form-control form-control-sm mr-2" placeholder="Tgl Keluar" value="{{ request('tanggal_keluar') }}">
            <select name="teknisi_id" class="form-control form-control-sm mr-2">
                <option value="">Teknisi</option>
                @foreach(\App\Models\User::all() as $teknisi)
                    <option value="{{ $teknisi->id }}" {{ request('teknisi_id') == $teknisi->id ? 'selected' : '' }}>{{ $teknisi->name }}</option>
                @endforeach
            </select>
            <button type="submit" class="btn btn-primary btn-sm">Filter</button>
        </form>
    </div>

    <div class="card">
        <div class="card-header bg-primary text-white">
            <h3 class="card-title">Stok Opname Alat</h3>
        </div>
        <div class="card-body p-2">
            <table class="table table-sm table-bordered table-hover">
                <thead class="bg-light">
                    <tr>
                        <th style="width: 30px;">No</th>
                        <th style="width: 130px;">Nama Alat</th>
                        <th style="width: 100px;">Serial</th>
                        <th style="width: 70px;">Status</th>
                        <th style="width: 90px;">Teknisi</th>
                        <th style="width: 90px;">Tgl Keluar</th>
                        <th style="width: 90px;">Tgl Masuk</th>
                        @if($canCrud)
                        <th style="width: 80px;">Aksi</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @forelse($alat as $no => $item)
                        <tr>
                            <td>{{ $no + $alat->firstItem() }}</td>
                            <td>{{ $item->nama_alat }}</td>
                            <td>{{ $item->serial_number }}</td>
                            <td>{{ ucfirst($item->status) }}</td>
                            <td>{{ $item->teknisi ? $item->teknisi->name : '-' }}</td>
                            <td>{{ $item->tanggal_keluar }}</td>
                            <td>{{ $item->tanggal_masuk }}</td>
                            @if($canCrud)
                            <td>
                                <button class="btn btn-warning btn-xs"
                                  data-toggle="modal"
                                  data-target="#modalEdit{{ $item->id }}">
                                  Edit
                                </button>
                                <button class="btn btn-danger btn-xs"
                                  data-toggle="modal"
                                  data-target="#modalDelete{{ $item->id }}">
                                  Hapus
                                </button>
                            </td>
                            @endif
                        </tr>

                        <!-- Modal Edit Alat -->
                        <div class="modal fade" id="modalEdit{{ $item->id }}" tabindex="-1" role="dialog">
                          <div class="modal-dialog" role="document">
                            <form method="POST" action="{{ route('stok-opname.update', $item->id) }}">
                              @csrf
                              @method('PUT')
                              <div class="modal-content">
                                <div class="modal-header">
                                  <h5 class="modal-title">Edit Alat</h5>
                                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                  </button>
                                </div>
                                <div class="modal-body">
                                  <!-- Isi sama seperti sebelumnya -->
                                  <div class="mb-2">
                                    <label>Nama Alat</label>
                                    <input type="text" name="nama_alat" class="form-control"
                                      value="{{ $item->nama_alat }}" required>
                                  </div>
                                  <div class="mb-2">
                                    <label>Serial Number</label>
                                    <input type="text" name="serial_number" class="form-control"
                                      value="{{ $item->serial_number }}">
                                  </div>
                                  <div class="mb-2">
                                    <label>Status</label>
                                    <select name="status" class="form-control" required>
                                      <option value="stok" {{ $item->status == 'stok' ? 'selected' : '' }}>Stok</option>
                                      <option value="keluar" {{ $item->status == 'keluar' ? 'selected' : '' }}>Keluar</option>
                                      <!--<option value="masuk" {{ $item->status == 'masuk' ? 'selected' : '' }}>Masuk</option>-->
                                    </select>
                                  </div>
                                  <div class="mb-2">
                                    <label>Keluar Untuk</label>
                                    <input type="text" name="keluar_untuk" class="form-control"
                                      value="{{ $item->keluar_untuk }}">
                                  </div>
                                  <div class="mb-2">
                                    <label>Teknisi</label>
                                    <select name="teknisi_id" class="form-control">
                                      <option value="">-</option>
                                      @foreach(\App\Models\User::all() as $teknisi)
                                        <option value="{{ $teknisi->id }}"
                                          {{ $item->teknisi_id == $teknisi->id ? 'selected' : '' }}>
                                          {{ $teknisi->name }}
                                        </option>
                                      @endforeach
                                    </select>
                                  </div>
                                  <div class="mb-2">
                                    <label>Tanggal Keluar</label>
                                    <input type="date" name="tanggal_keluar" class="form-control"
                                      value="{{ $item->tanggal_keluar }}">
                                  </div>
                                  <div class="mb-2">
                                    <label>Tanggal Masuk</label>
                                    <input type="date" name="tanggal_masuk" class="form-control"
                                      value="{{ $item->tanggal_masuk }}">
                                  </div>
                                  <div class="mb-2">
                                    <label>Sumber Masuk</label>
                                    <select name="sumber_masuk" class="form-control">
                                      <option value="">-</option>
                                      <option value="pembelian" {{ $item->sumber_masuk == 'pembelian' ? 'selected' : '' }}>Pembelian</option>
                                      <option value="pelanggan_berhenti" {{ $item->sumber_masuk == 'pelanggan_berhenti' ? 'selected' : '' }}>Pelanggan Berhenti</option>
                                    </select>
                                  </div>
                                  <div class="mb-2">
                                    <label>Keterangan</label>
                                    <textarea name="keterangan" class="form-control">{{ $item->keterangan }}</textarea>
                                  </div>
                                </div>
                                <div class="modal-footer">
                                  <button type="submit" class="btn btn-success btn-sm">Simpan</button>
                                  <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Batal</button>
                                </div>
                              </div>
                            </form>
                          </div>
                        </div>

                        <!-- Modal Delete Alat -->
                        <div class="modal fade" id="modalDelete{{ $item->id }}" tabindex="-1" role="dialog">
                          <div class="modal-dialog" role="document">
                            <form method="POST" action="{{ route('stok-opname.destroy', $item->id) }}">
                              @csrf
                              @method('DELETE')
                              <div class="modal-content">
                                <div class="modal-header">
                                  <h5 class="modal-title">Konfirmasi Hapus</h5>
                                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                  </button>
                                </div>
                                <div class="modal-body">
                                  <p>Yakin ingin menghapus alat <strong>{{ $item->nama_alat }} ({{ $item->serial_number }})</strong>?</p>
                                </div>
                                <div class="modal-footer">
                                  <button type="submit" class="btn btn-danger btn-sm">Hapus</button>
                                  <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Batal</button>
                                </div>
                              </div>
                            </form>
                          </div>
                        </div>
                    @empty
                        <tr>
                          <td colspan="8" class="text-center">Data tidak ditemukan.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
            <div class="d-flex justify-content-center">
                {{ $alat->links() }}
            </div>
            <br>
            Nb : keluar alat / masuk alat secod lewat menu edit. menu tambah untuk alat pembelian baru. 
        </div>
    </div>
</div>

<!-- Modal Tambah Alat -->
@if($canCrud)
<div class="modal fade" id="modalTambah" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <form method="POST" action="{{ route('stok-opname.store') }}">
      @csrf
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Tambah Alat</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <!-- Isi sama seperti sebelumnya -->
          <div class="mb-2">
            <label>Nama Alat</label>
            <input type="text" name="nama_alat" class="form-control" required>
          </div>
          <div class="mb-2">
            <label>Serial Number</label>
            <input type="text" name="serial_number" class="form-control">
          </div>
          <div class="mb-2">
            <label>Status</label>
            <select name="status" class="form-control" required>
              <option value="stok">Stok</option>
              <option value="keluar">Keluar</option>
              <!--<option value="masuk">Masuk</option>-->
            </select>
          </div>
          <div class="mb-2">
            <label>Keluar Untuk</label>
            <input type="text" name="keluar_untuk" class="form-control">
          </div>
          <div class="mb-2">
            <label>Teknisi</label>
            <select name="teknisi_id" class="form-control">
              <option value="">-</option>
              @foreach(\App\Models\User::all() as $teknisi)
                <option value="{{ $teknisi->id }}">{{ $teknisi->name }}</option>
              @endforeach
            </select>
          </div>
          <div class="mb-2">
            <label>Tanggal Keluar</label>
            <input type="date" name="tanggal_keluar" class="form-control">
          </div>
          <div class="mb-2">
            <label>Tanggal Masuk</label>
            <input type="date" name="tanggal_masuk" class="form-control">
          </div>
          <div class="mb-2">
            <label>Sumber Masuk</label>
            <select name="sumber_masuk" class="form-control">
              <option value="">-</option>
              <option value="pembelian">Pembelian</option>
              <option value="pelanggan_berhenti">Pelanggan Berhenti</option>
            </select>
          </div>
          <div class="mb-2">
            <label>Keterangan</label>
            <textarea name="keterangan" class="form-control"></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success btn-sm">Tambah</button>
          <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Batal</button>
        </div>
      </div>
    </form>
  </div>
</div>
@endif
@endsection