@extends('adminlte::page')

@section('title', 'Manajemen Site / Pusat Koneksi')

@section('content')
<div class="container">
    <h2 class="mb-3">Daftar Site / Pusat Koneksi</h2>
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="card shadow">
        <div class="card-body p-2">
            <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#modalTambahSite">
                Tambah Site
            </button>
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped table-sm mb-0 align-middle">
                    <thead class="bg-gradient-primary text-white">
                        <tr>
                            <th>No</th>
                            <th>Nama Site</th>
                            <th>Lokasi Site</th>
                            <th>Keterangan</th>
                            <th>Dibuat</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($sites as $site)
                        <tr>
                            <td>{{ $loop->iteration + ($sites->currentPage()-1)*$sites->perPage() }}</td>
                            <td>{{ $site->nama_site }}</td>
                            <td>{{ $site->lokasi_site }}</td>
                            <td>{{ $site->keterangan }}</td>
                            <td>{{ $site->created_at->format('d-m-Y H:i') }}</td>
                            <td>
                                <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#modalEditSite{{ $site->id }}">Edit</button>
                                <form action="{{ route('sites.destroy', $site->id) }}" method="POST" style="display:inline;">
                                    @csrf @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Yakin hapus site ini?')">Hapus</button>
                                </form>
                            </td>
                        </tr>
                        <!-- Modal Edit Site -->
                        <div class="modal fade" id="modalEditSite{{ $site->id }}" tabindex="-1">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <form action="{{ route('sites.update', $site->id) }}" method="POST">
                                        @csrf @method('PUT')
                                        <div class="modal-header">
                                            <h5 class="modal-title">Edit Site</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="mb-3">
                                                <label>Nama Site</label>
                                                <input type="text" name="nama_site" class="form-control" value="{{ $site->nama_site }}" required>
                                            </div>
                                            <div class="mb-3">
                                                <label>Lokasi Site</label>
                                                <input type="text" name="lokasi_site" class="form-control" value="{{ $site->lokasi_site }}">
                                            </div>
                                            <div class="mb-3">
                                                <label>Keterangan</label>
                                                <textarea name="keterangan" class="form-control">{{ $site->keterangan }}</textarea>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-success">Update</button>
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @endforeach
                        @if($sites->count() == 0)
                        <tr>
                            <td colspan="6" class="text-center">Tidak ada data site</td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            <div class="mt-2">
                {{ $sites->appends(request()->input())->links() }}
            </div>
        </div>
    </div>
</div>

<!-- Modal Tambah Site -->
<div class="modal fade" id="modalTambahSite" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('sites.store') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Site</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label>Nama Site</label>
                        <input type="text" name="nama_site" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Lokasi Site</label>
                        <input type="text" name="lokasi_site" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label>Keterangan</label>
                        <textarea name="keterangan" class="form-control"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
@endsection