@extends('adminlte::page')
@section('title', 'Rekap Upah Teknisi')
@section('content')
<div class="container">
    <h2 class="mb-3">Rekap Upah Teknisi</h2>
    <form method="GET" action="{{ route('rekap_upah.index') }}" class="row mb-4">
        <div class="col-md-2 mb-2">
            <input type="date" class="form-control form-control-sm" name="tanggal" value="{{ request('tanggal') }}">
        </div>
        <div class="col-md-2 mb-2">
            <input type="month" class="form-control form-control-sm" name="bulan" value="{{ request('bulan') }}">
        </div>
        <div class="col-md-2 mb-2">
            <select name="teknisi_id" class="form-control form-control-sm">
                <option value="">- Semua Teknisi -</option>
                @foreach($teknisis as $teknisi)
                <option value="{{ $teknisi->id }}" {{ request('teknisi_id') == $teknisi->id ? 'selected' : '' }}>
                    {{ $teknisi->name }}
                </option>
                @endforeach
            </select>
        </div>
        <div class="col-md-2 mb-2">
            <input type="text" class="form-control form-control-sm" name="nama_pelanggan" placeholder="Nama Pelanggan" value="{{ request('nama_pelanggan') }}">
        </div>
        <div class="col-md-2 mb-2">
            <select name="status_validasi" class="form-control form-control-sm">
                <option value="">- Semua Validasi -</option>
                <option value="pending" {{ request('status_validasi') == 'pending' ? 'selected' : '' }}>Pending</option>
                <option value="validated" {{ request('status_validasi') == 'validated' ? 'selected' : '' }}>Validated</option>
            </select>
        </div>
        <!--<div class="col-md-2 mb-2">
            <select name="per_page" class="form-control form-control-sm">
                @foreach([10, 20, 50, 100] as $n)
                <option value="{{ $n }}" {{ request('per_page', 20) == $n ? 'selected' : '' }}>{{ $n }} baris</option>
                @endforeach
            </select>
        </div>-->
        <div class="col-md-2 mb-2">
            <button type="submit" class="btn btn-primary btn-sm mr-1">Filter</button>
            <a href="{{ route('rekap_upah.index') }}" class="btn btn-secondary btn-sm">Reset</a>
        </div>
    </form>
    <p class="mb-1 font-weight-bold">
        Total Pengeluaran Upah: Rp {{ number_format($totalUpah,0,',','.') }}
    </p>
    <div class="card shadow">
        <div class="card-body p-2">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped table-sm mb-0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Teknisi</th>
                            <th>Tanggal</th>
                            <th>No Tiket</th>
                            <th>Nama Pelanggan</th>
                            <th>Pekerjaan</th>
                            <th>Upah (Rp)</th>
                            <th>Keterangan</th>
                            <th>Status Validasi</th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($rekapUpah as $row)
                        <tr>
                            <td>{{ $loop->iteration + ($rekapUpah->currentPage()-1)*$rekapUpah->perPage() }}</td>
                            <td>{{ $row->teknisi->name ?? '-' }}</td>
                            <td>{{ $row->jadwalTeknisi->tanggal ?? '-' }}</td>
                            <td>{{ $row->jadwalTeknisi->no_tiket ?? '-' }}</td>
                            <td>{{ $row->jadwalTeknisi->pelanggan->nama ?? 'Infra Linker' }}</td>
                            <td>{{ $row->jadwalTeknisi->deskripsi_tugas ?? '-' }}</td>
                            <td>{{ number_format($row->nominal_upah,0,',','.') }}</td>
                            <td>{{ $row->feedback_text ?? '-' }}</td>
                            <td>
                                <span class="badge badge-{{ $row->status_validasi=='validated' ? 'success' : 'warning' }}">
                                    {{ ucfirst($row->status_validasi) }}
                                </span>
                            </td>
                        </tr>
                    @endforeach
                    @if($rekapUpah->count()==0)
                        <tr><td colspan="9" class="text-center">Tidak ada data</td></tr>
                    @endif
                    </tbody>
                </table>
            </div>
            <div class="mt-2 mb-0">{{ $rekapUpah->appends(request()->input())->links() }}</div>
        </div>
    </div>
</div>
@endsection