@extends('adminlte::page')
@section('title', 'Rekap Pembayaran')

@section('content')
<div class="container">
    <h2 class="mb-3">Rekap Pembayaran</h2>
    <form method="GET" action="{{ route('rekap_pembayaran.index') }}" class="row mb-4">
    <div class="col-md-2 mb-2">
        <input type="text" class="form-control form-control-sm" name="nama" placeholder="Nama Pelanggan" value="{{ request('nama') }}">
    </div>
    <div class="col-md-2 mb-2">
        <select name="grub_id" class="form-control form-control-sm">
            <option value="">- Semua Grub -</option>
            @foreach($grubs as $grub)
            <option value="{{ $grub->id }}" {{ request('grub_id') == $grub->id ? 'selected' : '' }}>{{ $grub->nama_grub }}</option>
            @endforeach
        </select>
    </div>
    <div class="col-md-2 mb-2">
        <select name="status" class="form-control form-control-sm">
            <option value="">- Semua Status -</option>
            <option value="lunas" {{ request('status') == 'lunas' ? 'selected' : '' }}>Lunas</option>
            <option value="belum_lunas" {{ request('status') == 'belum_lunas' ? 'selected' : '' }}>Belum Lunas</option>
        </select>
    </div>
    <div class="col-md-2 mb-2">
        <input type="month" class="form-control form-control-sm" name="periode" value="{{ request('periode') }}">
    </div>
    <div class="col-md-2 mb-2">
        <select name="penagih_id" class="form-control form-control-sm">
            <option value="">- Semua Penagih -</option>
            @foreach($penagihs as $penagih)
            <option value="{{ $penagih->id }}" {{ request('penagih_id') == $penagih->id ? 'selected' : '' }}>{{ $penagih->name }}</option>
            @endforeach
        </select>
    </div>
    <div class="col-md-2 mb-2">
        <input type="date" class="form-control form-control-sm" name="tanggal_bayar" value="{{ request('tanggal_bayar') }}">
    </div>
    <div class="col-md-2 mb-2">
        <button type="submit" class="btn btn-primary btn-sm mr-1">Filter</button>
        <a href="{{ route('rekap_pembayaran.index') }}" class="btn btn-secondary btn-sm">Reset</a>
    </div>
</form>
@php
    $selisih = $totalTagihan - $totalDibayar;
    $persenSelisih = $totalTagihan > 0 ? ($selisih / $totalTagihan) * 100 : 0;
    $selisihBadge = $persenSelisih > 5 ? 'badge-danger' : 'badge-success';
@endphp

<p class="mb-3 font-weight-bold fs-4">
    <span class="badge badge-success fs-5 py-2 px-3">
        Total Tagihan: Rp {{ number_format($totalTagihan,0,',','.') }}
    </span>
    ||
    <span class="badge badge-warning text-dark fs-5 py-2 px-3">
        Total Pembayaran: Rp {{ number_format($totalDibayar,0,',','.') }}
    </span>
    ||
    <span class="badge {{ $selisihBadge }} fs-5 py-2 px-3">
        Total Bad Dept: Rp {{ number_format($selisih,0,',','.') }}
    </span>
</p>
    <div class="card shadow">
        <div class="card-body p-2">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped table-sm mb-0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama</th>
                            <th>Grub</th>
                            <th>Periode</th>
                            <th>Tagihan (Rp)</th>
                            <th>Dibayar (Rp)</th>
                            <th>Status</th>
                            <th>Tgl Bayar</th>
                            <th>Penagih</th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($pembayarans as $row)
                        <tr>
                            <td>{{ $loop->iteration + ($pembayarans->currentPage()-1)*$pembayarans->perPage() }}</td>
                            <td>{{ $row->pelanggan->nama ?? '-' }}</td>
                            <td>{{ $row->pelanggan->grub->nama_grub ?? '-' }}</td>
                            <td>{{ $row->periode }}</td>
                            <td>{{ number_format($row->jumlah_tagihan,0,',','.') }}</td>
                            <td>{{ number_format($row->jumlah_dibayar,0,',','.') }}</td>
                            <td>
                                <span class="badge badge-{{ $row->status=='lunas' ? 'success' : 'warning text-dark' }}">{{ ucfirst($row->status) }}</span>
                            </td>
                            <td>{{ $row->tanggal_bayar ?? '-' }}</td>
                            <td>{{ $row->pelanggan->penagih->name ?? '-' }}</td>
                        </tr>
                    @endforeach
                    @if($pembayarans->count()==0)
                        <tr><td colspan="9" class="text-center">Tidak ada data</td></tr>
                    @endif
                    </tbody>
                </table>
            </div>
            <div class="mt-2 mb-0">{{ $pembayarans->appends(request()->input())->links() }}</div>
        </div>
    </div>
</div>
@endsection