@extends('adminlte::page')

@section('title', 'Tagihan Belum Lunas Pelanggan')

@section('content_header')
    <h1>Tagihan Belum Lunas untuk {{ $pelanggan->nama }}</h1>
@stop

@section('content')
<div class="card">
    <div class="card-header">
        <a href="{{ route('pelanggan.index') }}" class="btn btn-primary btn-sm">Kembali</a>
    </div>
    <div class="card-body">
        <table class="table table-bordered table-hover table-striped">
            <thead>
                <tr>
                    <th>Bulan</th>
                    <th>Jumlah</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @forelse($tagihanBelumLunas as $pembayaran)
                <tr>
                    <td>{{ $pembayaran->bulan }}</td>
                    <td>Rp {{ number_format($pembayaran->jumlah, 0, ',', '.') }}</td>
                    <td><span class="badge bg-warning">Belum Lunas</span></td>
                </tr>
                @empty
                <tr>
                    <td colspan="3" class="text-center">Semua tagihan sudah lunas!</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@stop