@extends('adminlte::page')

@section('title', 'Detail Tagihan Pelanggan')

@section('content_header')
    <h1>Tagihan untuk {{ $pelanggan->nama }}</h1>
@stop

@section('content')
<div class="card">
    <div class="card-header">
        <a href="{{ route('pelanggan.index') }}" class="btn btn-primary btn-sm">Kembali</a>
    </div>
    <div class="card-body">
        <table class="table table-bordered table-hover table-striped">
            <thead>
                <tr>
                    <th>Bulan</th>
                    <th>Jumlah</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($pelanggan->pembayaran as $pembayaran)
                <tr>
                    <td>{{ $pembayaran->bulan }}</td>
                    <td>Rp {{ number_format($pembayaran->jumlah, 0, ',', '.') }}</td>
                    <td>
                        @if($pembayaran->status == 'lunas')
                            <span class="badge bg-success">Lunas</span>
                        @else
                            <span class="badge bg-warning">Belum Lunas</span>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@stop