@extends('adminlte::page')

@section('title', 'Detail Pelanggan')

@section('content')
<div class="container">
    <h3 class="mb-3">Detail Pelanggan: {{ $pelanggan->nama }}</h3>

    {{-- Modal Popup Cicilan --}}
    <div class="modal fade" id="modalCicil" tabindex="-1" aria-labelledby="modalCicilLabel" aria-hidden="true">
      <div class="modal-dialog">
        <form method="POST" id="form-cicil">
            @csrf
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="modalCicilLabel">Bayar Tagihan</h5>
                <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                  <input type="hidden" name="id_pembayaran" id="id_pembayaran">
                  <div class="mb-3">
                      <label for="jumlah_bayar" class="form-label">Nominal (Rp)</label>
                      <input type="number" name="jumlah_bayar" id="jumlah_bayar" class="form-control" min="1" required>
                      <small id="maxCicilan" class="text-muted"></small>
                  </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                <button type="submit" class="btn btn-success">Bayar</button>
              </div>
            </div>
        </form>
      </div>
    </div>

    <div class="card shadow">
        <div class="card-body p-2">
            <table class="table table-bordered table-hover table-striped mb-0">
                <thead>
                    <tr>
                        <th>Bulan</th>
                        <th>Tanggal Tagihan</th>
                        <th>Jumlah Tagihan (Rp)</th>
                        <th>Jumlah Dibayar (Rp)</th>
                        <th>TglBayar Terakhir</th>
                        <th>Status</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
@foreach($pelanggan->pembayaran as $pembayaran)
    @php
        $periode = $pembayaran->periode;
        $tanggal_berlangganan = $pelanggan->tanggal_berlangganan ?? null;
        $day = $tanggal_berlangganan ? \Carbon\Carbon::parse($tanggal_berlangganan)->day : 1;
        $tanggal_tagihan = $periode ? \Carbon\Carbon::createFromFormat('Y-m', $periode)->day($day) : null;
    @endphp
    <tr>
        <td>{{ $periode ? \Carbon\Carbon::createFromFormat('Y-m', $periode)->translatedFormat('M Y') : '-' }}</td>
        <td>{{ $tanggal_tagihan ? $tanggal_tagihan->format('d-m-Y') : '-' }}</td>
        <td>{{ number_format($pembayaran->jumlah_tagihan, 0, ',', '.') }}</td>
        <td>{{ number_format($pembayaran->jumlah_dibayar ?? 0, 0, ',', '.') }}</td>
        <td>
            {{ $pembayaran->tanggal_bayar ? \Carbon\Carbon::parse($pembayaran->tanggal_bayar)->format('d-m-Y') : '-' }}
        </td>
        <td>
            @if($pembayaran->status == 'lunas')
                <span class="badge bg-success">Lunas</span>
            @else
                <span class="badge bg-warning text-dark">Belum Lunas</span>
            @endif
        </td>
        <td>
            @if($pembayaran->status == 'belum_lunas')
            <button
                type="button"
                class="btn btn-success btn-xs btn-cicil"
                data-toggle="modal"
                data-target="#modalCicil"
                data-id="{{ $pembayaran->id }}"
                data-max="{{ $pembayaran->jumlah_tagihan - ($pembayaran->jumlah_dibayar ?? 0) }}"
                data-action="{{ route('pembayaran.cicil', $pembayaran->id) }}"
            >
                Bayar
            </button>
            @endif
        </td>
    </tr>
@endforeach
</tbody>
            </table>
            <div class="mt-2 mb-0">
                <a href="{{ route('grubs.show', $pelanggan->grub_id) }}" class="btn btn-secondary">Kembali ke Grub</a>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
document.addEventListener("DOMContentLoaded", function(){
    // Handler untuk tombol "Bayar Cicilan"
    document.querySelectorAll('.btn-cicil').forEach(function(btn){
        btn.addEventListener('click', function(){
            var id = this.getAttribute('data-id');
            var max = this.getAttribute('data-max');
            var action = this.getAttribute('data-action');
            // Set form action
            document.getElementById('form-cicil').setAttribute('action', action);
            document.getElementById('id_pembayaran').value = id;
            document.getElementById('jumlah_bayar').setAttribute('max', max);
            //document.getElementById('jumlah_bayar').value = '';
            document.getElementById('jumlah_bayar').value = max;
            document.getElementById('maxCicilan').innerText = 'Maksimal pembayaran: Rp ' + parseInt(max).toLocaleString('id-ID');
        });
    });
});
</script>
@endsection