@extends('adminlte::page')
@section('title', 'List Pelanggan')

@section('content')
<div class="container">
    <h2 class="mb-3">List Pelanggan</h2>
    <div class="card shadow">
        <div class="card-body p-2">
            <form method="GET" class="row g-2 mb-3">
                <div class="col-md-4 col-12">
                    <input type="text" name="search" value="{{ request('search') }}" class="form-control form-control-sm" placeholder="Cari Nama/IP/PPPoE/Site...">
                </div>
                <div class="col-md-3 col-12">
                    <select name="status" class="form-control form-control-sm">
                        <option value="">Semua Status</option>
                        <option value="aktif" {{ request('status')=='aktif' ? 'selected' : '' }}>Aktif</option>
                        <option value="suspend" {{ request('status')=='suspend' ? 'selected' : '' }}>Suspend</option>
                    </select>
                </div>
                <div class="col-md-2 col-4">
                    <button type="submit" class="btn btn-primary btn-sm w-100">Filter</button>
                </div>
                <div class="col-md-2 col-4">
                    <a href="{{ route('list-pelanggan.index') }}" class="btn btn-secondary btn-sm w-100">Reset</a>
                </div>
            </form>
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped table-sm align-middle mb-0">
                @php
function sort_link($field, $label, $sort, $direction) {
    $params = request()->except('page');
    $params['sort'] = $field;
    $params['direction'] = ($sort == $field && $direction == 'asc') ? 'desc' : 'asc';
    $icon = '';
    if ($sort == $field) {
        $icon = $direction == 'asc' ? '↑' : '↓';
    }
    $url = url()->current() . '?' . http_build_query($params);
    return '<a href="'.$url.'" style="color:inherit;text-decoration:none;">' . $label . ' ' . $icon . '</a>';
}
@endphp

<thead class="bg-gradient-primary text-white">
    <tr>
        <th>No</th>
        <th>{!! sort_link('nama', 'Nama', $sort ?? '', $direction ?? '') !!}</th>
        <th>{!! sort_link('ip_address', 'IP Address', $sort ?? '', $direction ?? '') !!}</th>
        <th>{!! sort_link('pppoe_username', 'PPPoE Username', $sort ?? '', $direction ?? '') !!}</th>
        <th>{!! sort_link('grub', 'Grub', $sort ?? '', $direction ?? '') !!}</th>
        <th>{!! sort_link('site', 'Site', $sort ?? '', $direction ?? '') !!}</th>
        <th>Qr Code</th>
        <th>{!! sort_link('status', 'Status', $sort ?? '', $direction ?? '') !!}</th>
    </tr>
</thead>
<tbody>
    @forelse($pelanggans as $pelanggan)
    <tr>
        <td>{{ $loop->iteration + ($pelanggans->currentPage()-1)*$pelanggans->perPage() }}</td>
        <td>
            <!-- Nama pelanggan jadi link tombol modal -->
            <a href="#" data-bs-toggle="modal" data-bs-target="#modalDetailPelanggan{{ $pelanggan->id }}">
                {{ $pelanggan->nama }}
            </a>
        </td>
        <td>{{ $pelanggan->ip_address ?: '-' }}</td>
        <td>{{ $pelanggan->pppoe_username ?: '-' }}</td>
        <td>{{ $pelanggan->grub->nama_grub ?: '-' }}</td>
        <td>{{ $pelanggan->site->nama_site ?? '-' }}</td>
        <td>
            @php
            $random = strtoupper(Str::random(4));
            $qrText = $random . '-' . $pelanggan->id;
            @endphp
            {!! QrCode::size(20)->generate($qrText) !!}
            &nbsp;
            <button
                onclick="window.open('{{ route('qr.print', ['text' => $qrText, 'name' => $pelanggan->nama, 'alamat' => $pelanggan->alamat]) }}', '_blank', 'width=400,height=500')"
                class="btn btn-outline-success btn-sm mt-2">
                    Print QR
            </button>
        </td>
        <td>
            @if($pelanggan->status == 'aktif')
                <span class="badge bg-success">Aktif</span>
            @else
                <span class="badge bg-danger">Suspend</span>
            @endif
        </td>
    </tr>

    <!-- Modal Detail Pelanggan -->
    <div class="modal fade" id="modalDetailPelanggan{{ $pelanggan->id }}" tabindex="-1">
      <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Detail Pelanggan : {{ $pelanggan->nama }}</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>
          <div class="modal-body">
            <ul class="list-group">
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>Status Berlangganan :</strong>
                  <span id="status{{ $pelanggan->id }}">
                    @if($pelanggan->status == 'suspend')
                      <span class="badge bg-danger">Suspend</span>
                    @else
                      <span class="badge bg-success">Aktif</span>
                    @endif
                  </span>
                </div>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>IP Address :</strong>
                  <span id="ip{{ $pelanggan->id }}">{{ $pelanggan->ip_address ?? '-' }}</span>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('ip{{ $pelanggan->id }}')" title="Copy IP">
                  <i class="fas fa-copy"></i>
                </button>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>PPPoE User/pass :</strong>
                  <span id="pppoe{{ $pelanggan->id }}">{{ $pelanggan->pppoe_username ?? '-' }}</span>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('pppoe{{ $pelanggan->id }}')" title="Copy PPPoE">
                  <i class="fas fa-copy"></i>
                </button>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>Alamat :</strong>
                  <span id="alamat{{ $pelanggan->id }}">{{ $pelanggan->alamat ?? '-' }}</span>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('alamat{{ $pelanggan->id }}')" title="Copy Alamat">
                  <i class="fas fa-copy"></i>
                </button>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>Kontak 1 :</strong>
                  @if($pelanggan->no_hp)
                    @php
                        $wa = preg_replace('/[^0-9]/','',$pelanggan->no_hp);
                    @endphp
                    <a href="https://wa.me/{{ $wa }}" target="_blank" class="text-success" id="kontak1{{ $pelanggan->id }}">
                        <i class="fab fa-whatsapp"></i> {{ $pelanggan->no_hp }}
                    </a>
                  @else
                    <span id="kontak1{{ $pelanggan->id }}">-</span>
                  @endif
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('kontak1{{ $pelanggan->id }}')" title="Copy Kontak 1">
                  <i class="fas fa-copy"></i>
                </button>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>Kontak 2 :</strong>
                  @if($pelanggan->no_hp2)
                    @php
                        $wa2 = preg_replace('/[^0-9]/','',$pelanggan->no_hp2);
                    @endphp
                    <a href="https://wa.me/{{ $wa2 }}" target="_blank" class="text-success" id="kontak2{{ $pelanggan->id }}">
                        <i class="fab fa-whatsapp"></i> {{ $pelanggan->no_hp2 }}
                    </a>
                  @else
                    <span id="kontak2{{ $pelanggan->id }}">-</span>
                  @endif
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('kontak2{{ $pelanggan->id }}')" title="Copy Kontak 2">
                  <i class="fas fa-copy"></i>
                </button>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>Keterangan :</strong>
                  <span id="keterangan{{ $pelanggan->id }}">{{ $pelanggan->keterangan ?? '-' }}</span>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('keterangan{{ $pelanggan->id }}')" title="Copy Keterangan">
                  <i class="fas fa-copy"></i>
                </button>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>Koordinat Lokasi :</strong>
                  <span id="koordinat{{ $pelanggan->id }}">{{ $pelanggan->koordinat_lokasi ?? '-' }}</span>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('koordinat{{ $pelanggan->id }}')" title="Copy Koordinat">
                  <i class="fas fa-copy"></i>
                </button>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>Maps lokasi :</strong>
                  <span id="maps{{ $pelanggan->id }}">{{ $pelanggan->google_maps_link ?? '-' }}</span>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('maps{{ $pelanggan->id }}')" title="Copy Maps">
                  <i class="fas fa-copy"></i>
                </button>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                  <strong>Site / Pusat Koneksi :</strong>
                  <span id="site{{ $pelanggan->id }}">
                    {{ $pelanggan->site->nama_site ?? '-' }}
                    @if($pelanggan->site && $pelanggan->site->lokasi_site)
                        <br><small class="text-muted">{{ $pelanggan->site->lokasi_site }}</small>
                    @endif
                  </span>
                </div>
                <button type="button" class="btn btn-light btn-sm" onclick="copyToClipboard('site{{ $pelanggan->id }}')" title="Copy Site">
                  <i class="fas fa-copy"></i>
                </button>
              </li>
              <li class="list-group-item">
                <strong>Foto Rumah :</strong>
                  @if($pelanggan->foto_rumah)
                  <br>
                      <img src="{{ asset('storage/' . $pelanggan->foto_rumah) }}" alt="Foto Rumah" class="img-thumbnail" style="max-width:250px;">
                  @else
                  -
                  @endif
              </li>
            </ul>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
          </div>
        </div>
      </div>
    </div>
    <!-- End Modal -->
    @empty
    <tr>
        <td colspan="8" class="text-center">Tidak ada data pelanggan</td>
    </tr>
    @endforelse
</tbody>
</table>
            </div>
            <div class="mt-2">
                {{ $pelanggans->links() }}
            </div>
            <br>
            Nb : klik disetiap header tabel untuk sort, klik setiap nama untuk tampilkan detail pelanggan..
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
function copyToClipboard(id) {
    var el = document.getElementById(id);
    if (!el) return;
    var text = el.innerText || el.textContent;
    navigator.clipboard.writeText(text).then(function() {
        alert('Copied!');
    });
}
</script>
@endsection