@extends('adminlte::page')

@section('title', 'Data Pelanggan')

@section('content')
<style>
    .sort-arrow {
        color: #fff !important;
        font-weight: bold;
        text-decoration: none;
        font-size: 1.2em;
        margin-left: 2px;
        margin-right: 2px;
        vertical-align: middle;
        transition: color 0.2s;
    }
    .sort-arrow:hover {
        color: #add8e6 !important;
    }
    @media (max-width: 600px) {
        .table th, .table td {
            font-size: 13px !important;
            padding: 6px 4px !important;
        }
        .table th {
            white-space: nowrap;
        }
        .table td {
            vertical-align: middle;
        }
        .badge, .btn {
            font-size: 12px !important;
            padding: 4px 8px !important;
        }
        .form-control, .btn {
            font-size: 13px !important;
        }
    }
</style>
<div class="container">
    <h2 class="mb-3">Data Pelanggan</h2>
    <div class="row mb-3 align-items-center">
        <div class="col-auto mb-2 mb-md-0">
            <a href="{{ route('pelanggan.create') }}" class="btn btn-primary btn-sm">Tambah Pelanggan</a>
        </div>
        <div class="col-auto mb-2 mb-md-0">
            <a href="{{ route('pembayaran.generate_tagihan') }}" class="btn btn-success btn-sm"
               onclick="return confirm('Generate tagihan untuk semua pelanggan bulan ini?')">
               Generate Tagihan Bulan Ini
            </a>
        </div>
        <div class="col">
            <form method="GET" action="{{ route('pelanggan.index') }}" class="form-row justify-content-end">
                <div class="col-12 col-md-auto mb-2 mb-md-0">
                    <input type="text" name="q" class="form-control form-control-sm" placeholder="Cari Nama Grub" value="{{ request('q') }}">
                </div>
                <div class="col-12 col-md-auto mb-2 mb-md-0">
                    <select name="status" class="form-control form-control-sm">
                        <option value="">-- Status Tagihan --</option>
                        <option value="lunas" {{ request('status') == 'lunas' ? 'selected' : '' }}>Lunas</option>
                        <option value="belum_lunas" {{ request('status') == 'belum_lunas' ? 'selected' : '' }}>Belum Lunas</option>
                    </select>
                </div>
                <div class="col-12 col-md-auto">
                    <button type="submit" class="btn btn-primary btn-sm mr-1">Filter</button>
                    <a href="{{ route('pelanggan.index') }}" class="btn btn-secondary btn-sm">Reset</a>
                </div>
            </form>
        </div>
    </div>
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    <div class="card shadow-sm">
        <div class="card-body p-2">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped table-sm mb-0 align-middle">
                    <thead class="bg-gradient-primary text-white text-center">
                        <tr>
                            <th style="width:40px;">No</th>
                            <th>Nama Grub</th>
                            <th>Jumlah Pelanggan</th>
                            <th class="text-right">Jumlah Tagihan (Rp)</th>
                            <th class="text-right">
                                Tagihan Belum Lunas (Rp)
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'belum_lunas_asc']) }}" title="Urutkan naik" class="sort-arrow">▲</a>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'belum_lunas_desc']) }}" title="Urutkan turun" class="sort-arrow">▼</a>
                            </th>
                            <th>Status Tagihan</th>
                            <th style="width:70px;">Detail</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($grubs as $grub)
                        @php
                            $allPayments = $grub->pelanggans->flatMap->pembayaran;
                            $total_tagihan = $allPayments->sum('jumlah_tagihan');
                            $total_tagihan_belum_lunas = $allPayments
                                ->where('status', 'belum_lunas')
                                ->sum(function($p) {
                                    return max(0, $p->jumlah_tagihan - ($p->jumlah_dibayar ?? 0));
                                });
                        @endphp
                        <tr>
                            <td>{{ $loop->iteration + ($grubs->currentPage()-1)*$grubs->perPage() }}</td>
                            <td style="min-width:120px">{{ $grub->nama_grub }}</td>
                            <td class="text-center">{{ $grub->pelanggans_count }}</td>
                            <td class="text-right">{{ number_format($total_tagihan, 0, ',', '.') }}</td>
                            <td class="text-right">{{ number_format($total_tagihan_belum_lunas, 0, ',', '.') }}</td>
                            <td>
                                @if($total_tagihan_belum_lunas > 0)
                                    <span class="badge badge-warning text-dark w-100">Tagihan Belum Lunas</span>
                                @else
                                    <span class="badge badge-success w-100">Semua Lunas</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('grubs.show', $grub->id) }}" class="btn btn-info btn-sm w-100">Detail</a>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center">Data grub tidak ditemukan.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="mt-2 mb-0">
                {{ $grubs->appends(request()->except('page'))->links() }}
            </div>
        </div>
    </div>
</div>
@endsection