@extends('adminlte::page')

@section('title', 'Edit Pelanggan')

@section('content')
<div class="container">
    <h1>Edit Pelanggan</h1>
    <form action="{{ route('pelanggan.update', $pelanggan->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label>Nama</label>
            <input type="text" name="nama" class="form-control" value="{{ old('nama', $pelanggan->nama) }}" required>
        </div>
        <div class="mb-3">
            <label>NIK (opsional)</label>
            <input type="text" name="nik" class="form-control" value="{{ old('nik', $pelanggan->nik) }}" maxlength="20">
        </div>
        <div class="mb-3">
            <label>Alamat</label>
            <input type="text" name="alamat" class="form-control" value="{{ old('alamat', $pelanggan->alamat) }}" required>
        </div>
        <div class="mb-3">
            <label>Keterangan (opsional)</label>
            <input type="text" name="keterangan" class="form-control" value="{{ old('keterangan', $pelanggan->keterangan) }}">
        </div>
        <div class="mb-3">
            <label>No HP (wajib format 628xxxxxxxxx)</label>
            <input type="text" name="no_hp" class="form-control" value="{{ old('no_hp', $pelanggan->no_hp) }}" required>
        </div>
        <div class="mb-3">
            <label>No HP 2 (opsional) (wajib format 628xxxxxxxxx)</label>
            <input type="text" name="no_hp2" class="form-control" value="{{ old('no_hp2', $pelanggan->no_hp2) }}">
        </div>
        <div class="mb-3">
    <label for="paket_wifi" class="form-label">Paket Wifi</label>
    <select name="paket_wifi" id="paket_wifi" class="form-control" required onchange="updateHargaPaket()">
        <option value="">-- Pilih Paket --</option>
        @foreach($pakets as $paket)
            <option value="{{ $paket->harga }}"
                data-harga="{{ $paket->harga }}"
                {{ old('paket_wifi', $pelanggan->paket_wifi) == $paket->harga ? 'selected' : '' }}>
                {{ $paket->nama_paket }} - Rp{{ number_format($paket->harga,0,',','.') }}
            </option>
        @endforeach
    </select>
</div>
<!--<div id="tampil-harga" class="mb-2"></div>-->
        <div class="mb-3">
            <label>Tanggal Berlangganan</label>
            <input type="date" name="tanggal_berlangganan" class="form-control"
                value="{{ old('tanggal_berlangganan', $pelanggan->tanggal_berlangganan ? date('Y-m-d', strtotime($pelanggan->tanggal_berlangganan)) : date('Y-m-d')) }}" required>
        </div>
        <div class="mb-3">
            <label for="grub_id">Grub</label>
            <select name="grub_id" id="grub_id" class="form-control" required>
                <option value="">-- Pilih Grub --</option>
                @foreach($grubs as $grub)
                    <option value="{{ $grub->id }}" {{ old('grub_id', $pelanggan->grub_id) == $grub->id ? 'selected' : '' }}>
                        {{ $grub->nama_grub }}
                    </option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
            <label for="penagih_id">Penagih</label>
            <select name="penagih_id" id="penagih_id" class="form-control" required>
                <option value="">-- Pilih Penagih --</option>
                @foreach($penagihs as $user)
                    <option value="{{ $user->id }}" {{ old('penagih_id', $pelanggan->penagih_id) == $user->id ? 'selected' : '' }}>
                        {{ $user->name }}
                    </option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
            <label>IP Address</label>
            <input type="text" name="ip_address" class="form-control" value="{{ old('ip_address', $pelanggan->ip_address) }}" placeholder="IP Address (opsional)">
        </div>
        <div class="mb-3">
            <label>PPPoE Username</label>
            <input type="text" name="pppoe_username" class="form-control" value="{{ old('pppoe_username', $pelanggan->pppoe_username) }}" placeholder="PPPoE Username (opsional)">
        </div>
        <div class="mb-3">
            <label>Koordinat Lokasi</label>
            <input type="text" name="koordinat_lokasi" class="form-control" value="{{ old('koordinat_lokasi', $pelanggan->koordinat_lokasi) }}" placeholder="Contoh: -7.12345,112.54321 (opsional)">
        </div>
        <div class="mb-3">
            <label>Link Google Maps (opsional)</label>
            <input type="url" name="google_maps_link" class="form-control" value="{{ old('google_maps_link', $pelanggan->google_maps_link) }}" placeholder="https://maps.google.com/...">
        </div>
        <div class="mb-3">
            <label for="site_id">Site / Pusat Koneksi</label>
            <select name="site_id" id="site_id" class="form-control" required>
                <option value="">-- Pilih Site --</option>
                @foreach($sites as $site)
                    <option value="{{ $site->id }}" {{ old('site_id', $pelanggan->site_id) == $site->id ? 'selected' : '' }}>
                        {{ $site->nama_site }}
                    </option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
    <label>Foto Rumah (opsional, JPG/PNG, max 2Mb)</label>
    <input type="file" name="foto_rumah" accept="image/*" class="form-control" id="fotoRumahInput">
    <div class="invalid-feedback d-none" id="fotoRumahError">
        Ukuran foto maksimal 2Mb !
    </div>
    @if(isset($pelanggan) && $pelanggan->foto_rumah)
        <br>
        <img src="{{ asset('storage/'.$pelanggan->foto_rumah) }}" alt="Foto Rumah" class="img-fluid mt-2" style="max-width:200px;">
        <br><small>Foto lama di atas. Jika ingin ganti, upload foto baru.</small>
    @endif
</div>
        <button type="submit" class="btn btn-success">Update</button>
        <a href="{{ route('grubs.show', $pelanggan->grub_id) }}" class="btn btn-secondary">Kembali</a>
    </form>
</div>
@endsection

@section('js')
<script>
document.addEventListener('DOMContentLoaded', function() {
    var input = document.getElementById('fotoRumahInput');
    var errorDiv = document.getElementById('fotoRumahError');
    if (input) {
        input.addEventListener('change', function() {
            if (input.files[0] && input.files[0].size > 2048 * 1024) { // 250KB
                input.value = '';
                errorDiv.classList.remove('d-none');
                alert('Ukuran foto terlalu besar! Maksimal 2 MB.');
            } else {
                errorDiv.classList.add('d-none');
            }
        });
    }
});
</script>
@endsection