@extends('adminlte::page')

@section('title', 'Tambah Pelanggan')

@section('content')
<div class="container">
    <h1>Tambah Pelanggan</h1>
    <form action="{{ route('pelanggan.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="mb-3">
            <label>Nama</label>
            <input type="text" name="nama" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>NIK (opsional)</label>
            <input type="text" name="nik" class="form-control" maxlength="20">
        </div>
        <div class="mb-3">
            <label>Alamat</label>
            <input type="text" name="alamat" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Keterangan (opsional)</label>
            <input type="text" name="keterangan" class="form-control">
        </div>
        <div class="mb-3">
            <label>No HP (628xxxxxxxxx)</label>
            <input type="text" name="no_hp" class="form-control" placeholder="wajib masukan format 62xxx" required>
        </div>
        <div class="mb-3">
            <label>No HP 2 (opsional) (628xxxxxxxxx)</label>
            <input type="text" name="no_hp2" class="form-control" placeholder="wajib masukan format 62xxx">
        </div>
        <div class="mb-3">
    <label for="paket_wifi" class="form-label">Paket Wifi</label>
    <select name="paket_wifi" id="paket_wifi" class="form-control" required onchange="updateHargaPaket()">
        <option value="">-- Pilih Paket --</option>
        @foreach($pakets as $paket)
            <option value="{{ $paket->harga }}"
                data-harga="{{ $paket->harga }}"
                {{ old('paket_wifi', (isset($pelanggan) ? $pelanggan->paket_wifi : '')) == $paket->harga ? 'selected' : '' }}>
                {{ $paket->nama_paket }} - Rp{{ number_format($paket->harga,0,',','.') }}
            </option>
        @endforeach
    </select>
</div>
<!--<div id="tampil-harga" class="mb-2"></div>-->
        <div class="mb-3">
            <label>Tanggal Berlangganan</label>
            <input type="date" name="tanggal_berlangganan" class="form-control" value="{{ old('tanggal_berlangganan', date('Y-m-d')) }}" required>
        </div>
        <div class="mb-3">
            <label for="grub_id">Grub</label>
            <select name="grub_id" id="grub_id" class="form-control" required>
                <option value="">-- Pilih Grub --</option>
                @foreach($grubs as $grub)
                    <option value="{{ $grub->id }}">{{ $grub->nama_grub }}</option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
            <label for="penagih_id">Penagih</label>
            <select name="penagih_id" id="penagih_id" class="form-control" required>
                <option value="">-- Pilih Penagih --</option>
                @foreach($penagihs as $user)
                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                @endforeach
            </select>
        </div>
        {{-- Tambahan field baru --}}
        <div class="mb-3">
            <label>IP Address</label>
            <input type="text" name="ip_address" class="form-control" placeholder="IP Address (opsional)">
        </div>
        <div class="mb-3">
            <label>PPPoE Username/Password</label>
            <input type="text" name="pppoe_username" class="form-control" placeholder="format = PPPoE Username / password">
        </div>
        <div class="mb-3">
            <label>Koordinat Lokasi</label>
            <input type="text" name="koordinat_lokasi" class="form-control" placeholder="Contoh: -7.12345,112.54321 (opsional)">
        </div>
        <div class="mb-3">
            <label>Link Google Maps (opsional)</label>
            <input type="url" name="google_maps_link" class="form-control" placeholder="https://maps.google.com/...">
        </div>
        <div class="mb-3">
            <label for="site_id">Site / Pusat Koneksi</label>
            <select name="site_id" id="site_id" class="form-control" required>
                <option value="">-- Pilih Site --</option>
                @foreach($sites as $site)
                    <option value="{{ $site->id }}">{{ $site->nama_site }}</option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
            <label>Foto Rumah (opsional, JPG/PNG, max 2Mb ( otomatis tercompress 250kb ))</label>
            <input type="file" name="foto_rumah" accept="image/*" class="form-control">
        </div>
        <button type="submit" class="btn btn-success">Simpan</button>
        <a href="{{ route('pelanggan.index') }}" class="btn btn-secondary">Kembali</a>
    </form>
</div>
@endsection

@section('js')
<script>
function updateHargaPaket() {
    var select = document.getElementById('paket_wifi');
    var harga = select.options[select.selectedIndex].getAttribute('data-harga');
    if(harga) {
        document.getElementById('tampil-harga').innerHTML = '<b>Harga Paket:</b> Rp' + Number(harga).toLocaleString('id-ID');
    } else {
        document.getElementById('tampil-harga').innerHTML = '';
    }
}
document.addEventListener('DOMContentLoaded', function() {
    updateHargaPaket();
});
</script>
@endsection