@extends('adminlte::page')

@section('title', 'Daftar Paket Internet')

@section('content_header')
    <h1 class="mb-2">Daftar Paket Internet</h1>
@stop

@section('content')
<div class="container">
    <div class="mb-2 d-flex justify-content-start">
        <a href="{{ route('paket_internet.create') }}" class="btn btn-primary btn-sm">
            <i class="fas fa-plus"></i> Tambah Paket
        </a>
    </div>
    <div class="card shadow">
        <div class="card-header bg-primary text-white">
            <span><i class="fas fa-wifi"></i> Paket Internet</span>
        </div>
        <div class="card-body p-2">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif
            <div class="table-responsive">
                @php
                function sort_link_paket($field, $label, $sort, $direction) {
                    $params = request()->except('page');
                    $params['sort'] = $field;
                    $params['direction'] = ($sort == $field && $direction == 'asc') ? 'desc' : 'asc';
                    $icon = '';
                    if ($sort == $field) {
                        $icon = $direction == 'asc' ? '↑' : '↓';
                    }
                    $url = url()->current() . '?' . http_build_query($params);
                    return '<a href="'.$url.'" style="color:inherit;text-decoration:none;">' . $label . ' ' . $icon . '</a>';
                }
                @endphp
                <table class="table table-bordered table-striped table-hover table-sm align-middle mb-0">
                    <thead class="bg-gradient-primary text-white">
                        <tr>
                            <th width="50">No</th>
                            <th>{!! sort_link_paket('nama_paket', 'Nama Paket', $sort ?? '', $direction ?? '') !!}</th>
                            <th>{!! sort_link_paket('harga', 'Harga', $sort ?? '', $direction ?? '') !!}</th>
                            <th width="120">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($pakets as $paket)
                        <tr>
                            <td>{{ $loop->iteration + ($pakets->currentPage()-1)*$pakets->perPage() }}</td>
                            <td>{{ $paket->nama_paket }}</td>
                            <td>
                                <span class="badge bg-info text-dark">Rp{{ number_format($paket->harga,0,',','.') }}</span>
                            </td>
                            <td>
                                <a href="{{ route('paket_internet.edit', $paket->id) }}" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i></a>
                                <form action="{{ route('paket_internet.destroy', $paket->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button onclick="return confirm('Yakin hapus?')" class="btn btn-danger btn-sm"><i class="fas fa-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="text-center">Tidak ada data paket internet</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <br>
            nb : klik header tabel untuk sort.
            <div class="mt-2">
                {{ $pakets->links() }}
            </div>
            
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
@endsection