@extends('adminlte::page')

@section('title', 'Edit Paket Internet')

@section('content_header')
    <h1>Edit Paket Internet</h1>
@stop

@section('content')
<div class="card">
    <div class="card-body">
        <form action="{{ route('paket_internet.update', $paket->id) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="mb-3">
                <label for="nama_paket" class="form-label">Nama Paket</label>
                <input type="text" name="nama_paket" id="nama_paket" class="form-control" value="{{ $paket->nama_paket }}" required>
            </div>
            <div class="mb-3">
                <label for="harga" class="form-label">Harga (Rp)</label>
                <input type="number" name="harga" id="harga" class="form-control" value="{{ $paket->harga }}" required>
            </div>
            <button class="btn btn-primary"><i class="fas fa-save"></i> Update</button>
            <a href="{{ route('paket_internet.index') }}" class="btn btn-secondary">Kembali</a>
        </form>
    </div>
</div>
@stop