@extends('adminlte::page')

@section('title', 'Penjadwalan Tugas Teknisi')

@section('css')
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
@stop

@section('content')
<div class="container">
    <h2 class="mb-3">Penjadwalan Teknisi</h2>
    <div class="row mb-3 align-items-center">
        <div class="col-auto">
            <a href="{{ route('jadwal-teknisi.create') }}" class="btn btn-primary btn-sm">Tambah Jadwal Tugas</a>
        </div>
        <div class="col">
        <form method="GET" action="{{ route('jadwal-teknisi.index') }}" class="row g-2 justify-content-end">
    <div class="col-auto">
        <input type="text" name="search_q" class="form-control form-control-sm" placeholder="Cari jadwal, teknisi, lokasi, dll..." value="{{ request('search_q') }}">
    </div>
    <div class="col-auto">
        <input type="date" name="search_tanggal" class="form-control form-control-sm" value="{{ request('search_tanggal') }}">
    </div>
    <div class="col-auto">
        <select name="search_status" class="form-control form-control-sm">
            <option value="">-- Status --</option>
            <option value="open" {{ request('search_status') == 'open' ? 'selected' : '' }}>Open</option>
            <option value="selesai_pending" {{ request('search_status') == 'selesai_pending' ? 'selected' : '' }}>Selesai & Belum Validasi</option>
            <option value="selesai_validated" {{ request('search_status') == 'selesai_validated' ? 'selected' : '' }}>Selesai & Validated</option>
        </select>
    </div>
    <div class="col-auto">
        <button type="submit" class="btn btn-primary btn-sm">Filter</button>
        <a href="{{ route('jadwal-teknisi.index') }}" class="btn btn-secondary btn-sm">Reset</a>
    </div>
</form>
        </div>
    </div>
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    <div class="card shadow">
        <div class="card-body p-2">
        <table class="table table-bordered table-hover table-striped mb-0">
    <thead class="bg-gradient-primary text-white">
        <tr>
            <th>No</th>
            <th>Nomor Tiket</th>
            <th>Teknisi</th>
            <th>Tanggal</th>
            <th>Lokasi</th>
            <th>Deskripsi Tugas</th>
            <th>Status</th>
            <th>Aksi</th>
            <th>Hapus</th>
        </tr>
    </thead>
    <tbody>
        @php
            $rownum = $jadwals->firstItem();
        @endphp
        @foreach($jadwals as $jadwal)
            @foreach($jadwal->jadwalTeknisiUsers as $jtuser)
            <tr>
                <td>{{ $rownum++ }}</td>
                <td>{{ $jadwal->no_tiket }}</td>
                <td>{{ $jtuser->teknisi->name }}</td>
                <td>{{ $jadwal->tanggal }}</td>
                <td>{{ $jadwal->lokasi ?: ($jadwal->pelanggan ? $jadwal->pelanggan->nama : '-') }}</td>
                <td>{{ $jadwal->deskripsi_tugas }}</td>
                <td>
                    @if($jtuser->status_feedback == 'selesai' && $jtuser->status_validasi == 'validated')
                        <span class="badge bg-success">Selesai & Validated</span>
                    @elseif($jtuser->status_feedback == 'selesai')
                        <span class="badge bg-warning">Selesai & Belum Validasi</span>
                    @else
                        <span class="badge bg-danger text-dark">Open</span>
                    @endif
                </td>
                <td>
                    <a href="{{ route('jadwal-teknisi.edit', $jadwal->id) }}" class="btn btn-warning btn-xs mb-1">Edit</a>
                    <button type="button" class="btn btn-success btn-xs mb-1"
                        data-bs-toggle="modal"
                        data-bs-target="#modalValidasi{{ $jtuser->id }}">
                        Validasi
                    </button>
                </td>
                <td>
                    <form action="{{ route('jadwal-teknisi.destroy', $jadwal->id) }}" method="POST" style="display:inline;">
                        @csrf @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-xs" onclick="return confirm('Yakin hapus jadwal?')">Hapus</button>
                    </form>
                </td>
            </tr>

            <!-- Modal Validasi per teknisi -->
            <div class="modal fade" id="modalValidasi{{ $jtuser->id }}" tabindex="-1" aria-labelledby="modalValidasiLabel{{ $jtuser->id }}" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <form method="POST" action="{{ route('jadwal-teknisi-user.validasi', $jtuser->id) }}">
                            @csrf
                            <div class="modal-header">
                                <h5 class="modal-title" id="modalValidasiLabel{{ $jtuser->id }}">Validasi Tugas Teknisi: {{ $jtuser->teknisi->name }}</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label>Keterangan Feedback Teknisi:</label>
                                    <div class="border p-2 rounded bg-light">
                                        {{ $jtuser->feedback_text ?? '-' }}
                                    </div>
                                </div>
                                @if($jtuser->feedback_photo)
                                <div class="mb-3">
                                    <label>Foto Feedback Teknisi:</label>
                                    <div>
                                        <img src="{{ asset('storage/'.$jtuser->feedback_photo) }}" alt="Foto Feedback" class="img-fluid rounded" style="max-width:200px;">
                                    </div>
                                </div>
                                @endif
                                @if($jtuser->nominal_bayar)
                                <div class="mb-3">
                                    <label>Nominal Bayar:</label>
                                    <div class="border p-2 rounded bg-light">
                                        Rp{{ number_format($jtuser->nominal_bayar, 0, ',', '.') }}
                                    </div>
                                </div>
                                @endif
                                @if($jtuser->metode_bayar)
                                <div class="mb-3">
                                    <label>Metode Bayar:</label>
                                    <div class="border p-2 rounded bg-light">
                                        {{ ucfirst($jtuser->metode_bayar) }}
                                    </div>
                                </div>
                                @endif
                                <hr>
                                <div class="mb-3">
                                    <label>Input Upah Teknisi</label>
                                    <input type="number" name="nominal_upah" min="0" class="form-control" value="{{ old('nominal_upah', $jtuser->nominal_upah) }}" required>
                                </div>
                                <div class="mb-3">
                                    <label>Keterangan Upah (Opsional)</label>
                                    <textarea name="keterangan_upah" class="form-control">{{ old('keterangan_upah', $jtuser->keterangan_upah ?? '') }}</textarea>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success">Simpan Validasi & Upah</button>
                                <form action="{{ route('jadwal-teknisi-user.open', $jtuser->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    <button type="submit" class="btn btn-secondary" onclick="return confirm('Buka kembali tugas untuk teknisi ini?')">Buka Kembali</button>
                                </form>
                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Tutup</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            @endforeach
        @endforeach
        @if($jadwals->count() == 0)
        <tr>
            <td colspan="9" class="text-center">Tidak ada data jadwal teknisi</td>
        </tr>
        @endif
    </tbody>
</table>
            <div class="mt-2 mb-0">
                {{ $jadwals->appends(request()->input())->links() }}
            </div>
        </div>
    </div>
</div>
@stop

@section('js')
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    $(function() {
        $("#search_teknisi").autocomplete({
            source: "{{ route('jadwal-teknisi.autocomplete-teknisi') }}",
            minLength: 1
        });
        $("#search_lokasi").autocomplete({
            source: "{{ route('jadwal-teknisi.autocomplete-lokasi') }}",
            minLength: 1
        });
    });
    </script>
@stop