@extends('adminlte::page')

@section('title', 'Feedback Tugas Teknisi')

@section('content')
<div class="container">
    <h3 class="mb-3">Feedback Tugas: {{ $jadwal->deskripsi_tugas }}</h3>
    <form method="POST" action="{{ route('jadwal-teknisi.feedback.submit', [$jadwal->id, $jadwal_teknisi_user->id]) }}" enctype="multipart/form-data">
        @csrf
        <div class="mb-3">
            <label for="feedback_text" class="form-label">Keterangan Feedback</label>
            <textarea name="feedback_text" class="form-control" required>{{ old('feedback_text', $jadwal_teknisi_user->feedback_text) }}</textarea>
        </div>
        <div class="mb-3">
            <label for="feedback_photo" class="form-label">Foto Dokumentasi</label>
            <input type="file" name="feedback_photo" class="form-control" accept="image/*">
            @if($jadwal_teknisi_user->feedback_photo)
                <img src="{{ asset('storage/'.$jadwal_teknisi_user->feedback_photo) }}" class="mt-2" width="120">
            @endif
        </div>
        <button type="submit" class="btn btn-success">Kirim Feedback & Selesaikan</button>
        <a href="{{ route('jadwal-saya') }}" class="btn btn-secondary">Kembali</a>
    </form>
</div>
@endsection