@extends('adminlte::page')

@section('title', 'Edit Jadwal Tugas Teknisi')

@section('content')

@section('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
/* === Tambahkan custom CSS di sini === */
.select2-container--default .select2-selection--multiple .select2-selection__choice {
    color: #212529 !important;
    background-color: #e9ecef !important;
    border: 1px solid #ced4da;
}
.select2-container--default .select2-selection--multiple .select2-search__field {
    color: #212529 !important;
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #212529 !important;
}
</style>
@stop


@if($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
@if(session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
@endif
@if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif

<div class="container">
    <h3 class="mb-3">Edit Jadwal Tugas Teknisi</h3>
    <form method="POST" action="{{ route('jadwal-teknisi.update', $jadwal->id) }}">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label for="jenis_tugas" class="form-label">Jenis Tugas</label>
            <select name="jenis_tugas" id="jenis_tugas" class="form-control" required>
                <option value="">-- Pilih Jenis --</option>
                <option value="mainten infra" {{ $jadwal->jenis_tugas == 'mainten infra' ? 'selected' : '' }}>Mainten Infra</option>
                <option value="mainten pelanggan" {{ $jadwal->jenis_tugas == 'mainten pelanggan' ? 'selected' : '' }}>Mainten Pelanggan</option>
                <option value="pemasangan baru" {{ $jadwal->jenis_tugas == 'pemasangan baru' ? 'selected' : '' }}>Pemasangan Baru</option>
            </select>
        </div>

        <div class="mb-3">
            <label>No Tiket</label>
            <input type="text" name="no_tiket" id="no_tiket" class="form-control" value="{{ $jadwal->no_tiket }}" readonly>
        </div>

        <div class="mb-3">
            <label for="tanggal" class="form-label">Tanggal Tugas</label>
            <input type="date" name="tanggal" id="tanggal" class="form-control" value="{{ $jadwal->tanggal }}" required>
        </div>
        <div class="mb-3">
            <label>Hari</label>
            <input type="text" id="nama_hari" class="form-control" value="{{ $jadwal->nama_hari }}" readonly>
        </div>

        {{-- Dynamic fields --}}
        <div id="field-lokasi" class="mb-3" style="display:none;">
            <label for="lokasi" class="form-label">Lokasi</label>
            <input type="text" name="lokasi" id="lokasi" class="form-control" value="{{ $jadwal->lokasi }}">
        </div>
        <div id="field-nama-pelanggan" class="mb-3" style="display:none;">
            <label for="pelanggan_id" class="form-label">Nama Pelanggan</label>
            <select name="pelanggan_id" id="pelanggan_id" class="form-control select2">
                <option value="">-- Pilih Pelanggan --</option>
                @foreach($pelanggans as $pelanggan)
                    <option value="{{ $pelanggan->id }}" {{ $jadwal->pelanggan_id == $pelanggan->id ? 'selected' : '' }}>{{ $pelanggan->nama }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label for="deskripsi_tugas" class="form-label">Deskripsi Tugas</label>
            <textarea name="deskripsi_tugas" id="deskripsi_tugas" class="form-control" required>{{ $jadwal->deskripsi_tugas }}</textarea>
        </div>

        <div class="mb-3">
            <label for="teknisi_id" class="form-label">Teknisi (bisa lebih dari 1)</label>
            <select name="teknisi_id[]" id="teknisi_id" class="form-control select2" multiple required>
                @foreach($teknisis as $teknisi)
                    <option value="{{ $teknisi->id }}" {{ in_array($teknisi->id, $jadwal->teknisi_ids ?? []) ? 'selected' : '' }}>{{ $teknisi->name }}</option>
                @endforeach
            </select>
            <small>Pilih teknisi dengan tap (bisa pilih lebih dari satu, support HP)</small>
        </div>

        <input type="hidden" name="status" value="Open">

        <button type="submit" class="btn btn-primary">Update Jadwal</button>
        <a href="{{ route('jadwal-teknisi.index') }}" class="btn btn-secondary">Kembali</a>
    </form>
</div>
@endsection

@section('js')
<!-- Pakai Select2 agar multi select friendly di HP -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
    $('.select2').select2({
        width: '100%',
        dropdownAutoWidth: true
    });

    // Set dynamic fields on page load
    var jenis = $('#jenis_tugas').val();
    if (jenis === 'mainten infra') {
        $('#field-lokasi').show();
        $('#field-nama-pelanggan').hide();
    } else if (jenis === 'mainten pelanggan' || jenis === 'pemasangan baru') {
        $('#field-nama-pelanggan').show();
        $('#field-lokasi').hide();
    } else {
        $('#field-lokasi').hide();
        $('#field-nama-pelanggan').hide();
    }

    $('#jenis_tugas').change(function() {
        var jenis = $(this).val();
        $('#field-lokasi').hide();
        $('#field-nama-pelanggan').hide();

        // generate no tiket
        $.get("{{ route('jadwal-teknisi.generate-tiket') }}", { jenis_tugas: jenis }, function(res){
            $('#no_tiket').val(res.no_tiket);
        });

        if (jenis === 'mainten infra') {
            $('#field-lokasi').show();
        }
        if (jenis === 'mainten pelanggan' || jenis === 'pemasangan baru') {
            $('#field-nama-pelanggan').show();
        }
    });

    $('#tanggal').change(function() {
        var tanggal = $(this).val();
        if (tanggal) {
            var hari = new Date(tanggal).toLocaleDateString('id-ID', {weekday:'long'});
            $('#nama_hari').val(hari);
        } else {
            $('#nama_hari').val('');
        }
    });
});
</script>
@endsection