@extends('adminlte::page')

@section('title', 'Detail Grub')

@section('content')
<div class="container">
    <h3 class="mb-3">Detail Grub: {{ $grub->nama_grub }}</h3>
    <div class="card shadow">
        <div class="card-body p-2">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped table-sm mb-0">
                <thead>
    <tr>
        <th>No</th>
        <th>Nama</th>
        <th>Penagih</th>
        <th>Alamat</th>
        <th>No HP</th>
        <th>Paket Wifi</th>
        <th>Status</th>
        <th>Status Tagihan</th>
        <th>Detail Tagihan</th>
    </tr>
</thead>
<tbody>
@foreach($grub->pelanggans as $pelanggan)
    @php
        $total_tunggakan = $pelanggan->pembayaran
            ->where('status', 'belum_lunas')
            ->sum(function($pembayaran) {
                return ($pembayaran->jumlah_tagihan - ($pembayaran->jumlah_dibayar ?? 0));
            });
    @endphp
    <tr>
        <td>{{ $loop->iteration }}</td>
        <td>
            <a href="#" 
                data-bs-toggle="modal" 
                data-bs-target="#modalDetailTeknis{{ $pelanggan->id }}"
                style="font-weight:bold; color:#0d6efd;">
                {{ $pelanggan->nama }}
            </a>
        </td>
        <td>{{ $pelanggan->penagih->name ?? '-' }}</td>
        <td>{{ $pelanggan->alamat }}</td>
        <td>{{ $pelanggan->no_hp }}</td>
        <td>{{ number_format($pelanggan->paket_wifi, 0, ',', '.') }}</td>
        <td>
            @if($pelanggan->status == 'suspend')
                <span class="badge badge-danger">Suspend</span>
            @else
                <span class="badge badge-success">Aktif</span>
            @endif
        </td>
        <td>
            @if($pelanggan->pembayaran->where('status', 'belum_lunas')->count() > 0)
                <span class="badge badge-warning text-dark">
                    Belum Lunas {{ $total_tunggakan > 0 ? number_format($total_tunggakan, 0, ',', '.') : '-' }}
                </span>
            @else
                <span class="badge badge-success">Lunas</span>
            @endif
        </td>
        <td>
            <a href="{{ route('pelanggan.show', $pelanggan->id) }}" class="btn btn-info btn-xs">Detail Tagihan</a>
            <a href="{{ route('pelanggan.edit', $pelanggan->id) }}" class="btn btn-warning btn-xs">Edit</a>
            <input type="hidden" name="grub_id" value="{{ $pelanggan->grub_id }}">
            || &nbsp
            @if($pelanggan->status == 'aktif')
                <form method="POST" action="{{ route('pelanggan.suspend', $pelanggan->id) }}" style="display:inline;">
                @csrf
                    <button type="submit" class="btn btn-danger btn-xs" onclick="return confirm('Suspend pelanggan ini?')">Suspend</button>
                </form>
            @else
                <form method="POST" action="{{ route('pelanggan.aktifkan', $pelanggan->id) }}" style="display:inline;">
                @csrf
                    <button type="submit" class="btn btn-success btn-xs" onclick="return confirm('Aktifkan pelanggan?')">Aktifkan</button>
                </form>
            @endif
        </td>
    </tr>

    <!-- Modal Detail Teknis Pelanggan -->
    <div class="modal fade" id="modalDetailTeknis{{ $pelanggan->id }}" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Detail Teknis Pelanggan: {{ $pelanggan->nama }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <ul class="list-group">
                        <li class="list-group-item">
                            <strong>IP Address:</strong> {{ $pelanggan->ip_address ?? '-' }}
                        </li>
                        <li class="list-group-item">
                            <strong>PPPoE (user/pass):</strong> {{ $pelanggan->pppoe_username ?? '-' }}
                        </li>
                        <li class="list-group-item">
                            <strong>Alamat :</strong> {{ $pelanggan->alamat ?? '-' }}  
                        </li>
                        <li class="list-group-item">
                            <strong>Kontak 1 :</strong> {{ $pelanggan->no_hp ?? '-' }}  
                        </li>
                        <li class="list-group-item">
                            <strong>Kontak 2 :</strong> {{ $pelanggan->no_hp2 ?? '-' }}  
                        </li>
                        <li class="list-group-item">
                            <strong>Keterangan :</strong> {{ $pelanggan->keterangan ?? '-' }}  
                        </li>
                        <li class="list-group-item">
                            <strong>Koordinat Lokasi:</strong> {{ $pelanggan->koordinat_lokasi ?? '-' }}
                        </li>
                        <li class="list-group-item">
                            <strong>Maps Lokasi:</strong><a href="{{ $pelanggan->google_maps_link ?? '-' }}" target="_blank"> {{ $pelanggan->google_maps_link ?? '-' }}</a>
                        </li>
                        <li class="list-group-item">
                            <strong>Site / Pusat Koneksi:</strong> {{ $pelanggan->site->nama_site ?? '-' }}
                            @if($pelanggan->site && $pelanggan->site->lokasi_site)
                                <br><small class="text-muted">{{ $pelanggan->site->lokasi_site }}</small>
                            @endif
                        </li>
                        <li class="list-group-item">
                            <strong>Foto Rumah:</strong>
                                @if($pelanggan->foto_rumah)
                                <br>
                                    <img src="{{ asset('storage/' . $pelanggan->foto_rumah) }}" alt="Foto Rumah" class="img-thumbnail" style="max-width:250px;">
                                @else
                                -
                                @endif
                        </li>
                    </ul>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                </div>
            </div>
        </div>
    </div>
@endforeach
</tbody>
                </table>
            </div>
            <div class="mt-2 mb-0">
                <a href="{{ route('pelanggan.index') }}" class="btn btn-secondary">Kembali</a>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
@endsection