@extends('adminlte::page')

@section('title', 'Daftar Grub')

@section('content')
<div class="container">
    <div class="mb-3">
        <a href="{{ route('grubs.create') }}" class="btn btn-success">
            + Tambah Grub
        </a>
    </div>
    <div class="card">
        <div class="card-header bg-primary text-white">
            <h3 class="card-title">Daftar Grub</h3>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-hover">
                <thead class="bg-light">
                    <tr>
                        <th>No</th>
                        <th>Nama Grub</th>
                        <th>Keterangan</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($grubs as $no => $grub)
                        <tr>
                            <td>{{ $no + 1 }}</td>
                            <td>{{ $grub->nama_grub }}</td>
                            <td>{{ $grub->keterangan }}</td>
                            <td>
                                <a href="{{ route('grubs.edit', $grub->id) }}" class="btn btn-warning btn-sm">Edit</a>
                                <form action="{{ route('grubs.destroy', $grub->id) }}" method="POST" style="display:inline;">
                                    @csrf @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin hapus?')">Hapus</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">Belum ada data grub.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection