@extends('adminlte::page')
@section('title', 'Dashboard Teknisi')

@section('content')
<style>
    .dashboard-card {
        border: none;
        border-radius: 1.1rem;
        box-shadow: 0 4px 16px rgba(0,0,0,.08);
        min-height: 140px;
        position: relative;
        overflow: hidden;
        background: #f7fafd;
        transition: transform .18s, box-shadow .18s;
        cursor: pointer;
        text-decoration: none !important;
        display: block;
    }
    .dashboard-card:hover {
        transform: translateY(-4px) scale(1.01);
        box-shadow: 0 10px 32px rgba(0,0,0,.15);
        z-index: 2;
        filter: brightness(0.97);
    }
    .dashboard-card .icon {
        font-size: 2.5rem;
        position: absolute;
        top: 1rem;
        right: 1.3rem;
        opacity: 0.25;
        z-index: 0;
        pointer-events: none;
    }
    .dashboard-card .card-body {
        z-index: 1;
        position: relative;
        padding-top: 1.1rem;
    }
    .dashboard-value {
        font-size: 1.8rem;
        font-weight: bold;
        line-height: 1.1;
        margin-bottom: .2rem;
    }
    .dashboard-label {
        font-size: 1.08rem;
        font-weight: 600;
        margin-bottom: .37rem;
        letter-spacing: 0.5px;
    }
    .soft-blue { background: #e3f0fa; color:#1565c0;}
    .soft-green { background: #eafbe7; color:#388e3c;}
    .soft-yellow { background: #fffde7; color:#fbc02d;}
    .soft-grey { background: #f5f5f5; color:#616161;}
    .icon-blue { color:#1565c0; }
    .icon-green { color:#388e3c;}
    .icon-yellow { color:#fbc02d;}
    .icon-grey { color:#616161;}
    @media (max-width: 600px) {
        .dashboard-value { font-size: 1.2rem; }
        .dashboard-label { font-size: 0.93rem; }
        .dashboard-card { min-height: 80px; }
    }
    /* Table styling */
    .table-dashboard {
        font-size: 0.97rem;
        border-radius: 1em;
        overflow: hidden;
        background: #fff;
        box-shadow: 0 2px 10px rgba(0,0,0,.07);
    }
    .table-dashboard thead {
        background: linear-gradient(90deg,#43a047 60%,#00bcd4 100%);
        color: #fff;
        font-size: 1.03rem;
    }
    .table-dashboard th, .table-dashboard td {
        vertical-align: middle !important;
    }
    .table-dashboard tbody tr:nth-child(even) {
        background: #f7fafd;
    }
    .table-dashboard tbody tr:hover {
        background: #e3f0fa;
        transition: background .15s;
    }
    .badge-status {
        font-size: 0.9em;
        border-radius: 0.5em;
        padding: 0.35em 0.9em;
        font-weight: 500;
        letter-spacing: .3px;
    }
    .badge-done { background: #388e3c; color: #fff; }
    .badge-open { background: #fbc02d; color: #444;}
    .badge-pending { background: #1565c0; color: #fff;}
</style>
<div class="container-fluid">
    <h3 class="mb-4 fw-bold text-dark"><i class="fas fa-tools me-2"></i>Dashboard Teknisi</h3>
    <div class="row g-3">
        <div class="col-lg-3 col-md-4 col-6">
            <div class="card dashboard-card soft-blue">
                <span class="icon icon-blue"><i class="fas fa-calendar-alt"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Total Tugas Bulan Ini</div>
                    <div class="dashboard-value">{{ $totalTugasBulanIni }}</div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-4 col-6">
            <div class="card dashboard-card soft-green">
                <span class="icon icon-green"><i class="fas fa-check-circle"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Tugas Selesai Bulan Ini</div>
                    <div class="dashboard-value">{{ $tugasSelesaiBulanIni }}</div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-4 col-6">
            <div class="card dashboard-card soft-yellow">
                <span class="icon icon-yellow"><i class="fas fa-tasks"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Tugas Belum Selesai</div>
                    <div class="dashboard-value">{{ $tugasBelumSelesai }}</div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-4 col-6">
            <div class="card dashboard-card soft-grey">
                <span class="icon icon-grey"><i class="fas fa-calendar-day"></i></span>
                <div class="card-body">
                    <div class="dashboard-label">Tugas Hari Ini</div>
                    <div class="dashboard-value">{{ $tugasHariIni }}</div>
                </div>
            </div>
        </div>
    </div>

    <!-- TABEL TUGAS TERBARU -->
    <div class="card mt-4">
        <div class="card-header bg-success text-white">
            <i class="fas fa-list"></i> Daftar Tugas Terbaru
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-dashboard table-hover mb-0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>No Tiket</th>
                            <th>Jenis Tugas</th>
                            <th>Nama Pelanggan</th>
                            <th>Lokasi</th>
                            <th>Tanggal</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($tugasTerbaru as $t)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $t->no_tiket }}</td>
                            <td>{{ $t->jenis_tugas }}</td>
                            <td>{{ $t->nama_pelanggan }}</td>
                            <td>{{ $t->lokasi }}</td>
                            <td>{{ \Carbon\Carbon::parse($t->tanggal)->format('d M Y') }}</td>
                            <td>
                                @if($t->status == 'selesai')
                                    <span class="badge badge-status badge-done"><i class="fas fa-check"></i> Selesai</span>
                                @elseif($t->status == 'open')
                                    <span class="badge badge-status badge-open"><i class="fas fa-hourglass-half"></i> Open</span>
                                @else
                                    <span class="badge badge-status badge-pending"><i class="fas fa-clock"></i> Pending</span>
                                @endif
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center text-danger">Tidak ada tugas terbaru.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection