<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('jadwal_teknisis', function (Blueprint $table) {
            $table->id();
            $table->foreignId('teknisi_id')->constrained('users');
            $table->date('tanggal');
            $table->string('lokasi');
            $table->text('deskripsi_tugas');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('jadwal_teknisis');
    }
};
