<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use SimpleSoftwareIO\QrCode\BaconQrCodeGenerator;

class QrCodeServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton(BaconQrCodeGenerator::class, function ($app) {
            return new BaconQrCodeGenerator();
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        config(['qrcode.image_backend' => 'gd']);
    }
}