<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StokAlat extends Model
{
    use HasFactory;

    protected $table = 'stok_alat'; // pastikan sesuai nama tabel
    protected $fillable = [
        'nama_alat',
        'serial_number',
        'status',
        'keluar_untuk',
        'teknisi_id',
        'tanggal_keluar',
        'tanggal_masuk',
        'sumber_masuk',
        'keterangan'
    ];

    // Relasi ke teknisi
    public function teknisi()
    {
        return $this->belongsTo(User::class, 'teknisi_id');
    }
}