<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Pelanggan extends Model
{
    use HasFactory;

    protected $fillable = [
        'nama', 'nik', 'alamat', 'keterangan', 'no_hp', 'no_hp2', 'paket_wifi',
        'tanggal_berlangganan', 'grub_id', 'penagih_id', 'ip_address',
        'pppoe_username', 'koordinat_lokasi', 'google_maps_link', 'site_id',
        'foto_rumah'
    ];

    public function pembayaran()
    {
        return $this->hasMany(Pembayaran::class);
    }

    public function grub()
    {
        return $this->belongsTo(Grub::class);
    }

    public function penagih()
    {
        return $this->belongsTo(User::class, 'penagih_id');
    }

    public function site() {
        return $this->belongsTo(Site::class);
    }

}