<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JadwalTeknisiUser extends Model
{
    use HasFactory;

    protected $table = 'jadwal_teknisi_user';

    protected $fillable = [
        'jadwal_teknisi_id',
        'teknisi_id',
        'feedback_text',
        'feedback_photo',
        'nominal_upah',
        'nominal_bayar',     // <--- baru
        'metode_bayar',      // <--- baru
        'status_feedback',
        'status_validasi',
        'feedback_at'
    ];

    public function jadwalTeknisi()
    {
        return $this->belongsTo(JadwalTeknisi::class, 'jadwal_teknisi_id');
    }

    public function teknisi()
    {
        return $this->belongsTo(User::class, 'teknisi_id');
    }
}