<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class JadwalTeknisi extends Model
{
    protected $fillable = [
        'no_tiket',
        'jenis_tugas',
        'tanggal',
        'nama_hari',
        'lokasi',
        'pelanggan_id',
        'deskripsi_tugas',
        'status',
        'created_by'
    ];

    public function jadwalTeknisiUsers()
{
    return $this->hasMany(JadwalTeknisiUser::class, 'jadwal_teknisi_id');
}

public function pelanggan()
{
    return $this->belongsTo(\App\Models\Pelanggan::class, 'pelanggan_id');
}


}
