<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HistoriAlat extends Model
{
    protected $table = 'histori_alat';

    protected $fillable = [
        'stok_alat_id',
        'jenis',          // enum: keluar, masuk
        'keluar_untuk',
        'teknisi_id',
        'tanggal',
        'sumber_masuk',   // enum: pembelian, pelanggan_berhenti
        'keterangan',
    ];

    // Relasi ke StokAlat
    public function alat()
    {
        return $this->belongsTo(StokAlat::class, 'stok_alat_id');
    }

    // Relasi ke User (teknisi)
    public function teknisi()
    {
        return $this->belongsTo(User::class, 'teknisi_id');
    }
}