<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class UserController extends Controller
{
    // List user
    public function index()
    {
        $users = User::with('roles')->get();
        return view('users.index', compact('users'));
    }

    public function create()
{
    $roles = \Spatie\Permission\Models\Role::all();
    return view('users.create', compact('roles'));
}

public function store(Request $request)
{
    $request->validate([
        'name' => ['required', 'string', 'max:255'],
        'email' => ['required', 'string', 'email', 'max:255', 'unique:users,email'],
        'role' => ['required', 'array'],
        'role.*' => ['string', 'exists:roles,name'],
        'password' => ['required', 'confirmed', 'min:6'],
    ]);

    $user = new User();
    $user->name = $request->name;
    $user->email = $request->email;
    $user->password = \Hash::make($request->password);
    $user->save();

    // assign roles
    $user->syncRoles($request->role);

    return redirect()->route('users.index')
        ->with('success', 'User berhasil ditambahkan!');
}



    // Form edit user
    public function edit($id)
    {
        $user = User::findOrFail($id);
        $roles = Role::all(); // Ambil semua role dari DB
        return view('users.edit', compact('user', 'roles'));
    }

    // Simpan perubahan user
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users,email,'.$id],
            'role' => ['required', 'array'],
            'role.*' => ['string', 'exists:roles,name'], // validasi nama role dinamis
            'password' => ['nullable', 'confirmed', 'min:6'],
        ]);
    
        $user = User::findOrFail($id);
        $user->name = $request->name;
        $user->email = $request->email;
        if ($request->filled('password')) {
            $user->password = Hash::make($request->password);
        }
        $user->save();
    
        // Update roles (array nama role)
        $user->syncRoles($request->role);
    
        return redirect()->route('users.index')
            ->with('success', 'User berhasil diupdate!');
    }

    // Hapus user
    public function destroy($id)
    {
        $user = User::findOrFail($id);
        $user->delete();

        return redirect()->route('users.index')
            ->with('success', 'User berhasil dihapus!');
    }
}