<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use DB;
//use Carbon\Carbon;


class TeknisiDashboardController extends Controller
{

public function index()
{
    $userId = auth()->id();
    $bulanIni = Carbon::now()->format('Y-m');
    $hariIni = Carbon::now()->format('Y-m-d');

    // Total tugas bulan ini (yang di-assign ke teknisi)
    $totalTugasBulanIni = \DB::table('jadwal_teknisi_user')
        ->join('jadwal_teknisis', 'jadwal_teknisi_user.jadwal_teknisi_id', '=', 'jadwal_teknisis.id')
        ->where('jadwal_teknisi_user.teknisi_id', $userId)
        ->where('jadwal_teknisis.tanggal', 'like', $bulanIni.'%')
        ->count();

    // Tugas selesai bulan ini
    $tugasSelesaiBulanIni = \DB::table('jadwal_teknisi_user')
        ->join('jadwal_teknisis', 'jadwal_teknisi_user.jadwal_teknisi_id', '=', 'jadwal_teknisis.id')
        ->where('jadwal_teknisi_user.teknisi_id', $userId)
        ->where('jadwal_teknisis.tanggal', 'like', $bulanIni.'%')
        ->where('jadwal_teknisis.status', 'selesai')
        ->count();

    // Tugas belum selesai
    $tugasBelumSelesai = \DB::table('jadwal_teknisi_user')
        ->join('jadwal_teknisis', 'jadwal_teknisi_user.jadwal_teknisi_id', '=', 'jadwal_teknisis.id')
        ->where('jadwal_teknisi_user.teknisi_id', $userId)
        ->where('jadwal_teknisis.tanggal', 'like', $bulanIni.'%')
        ->whereIn('jadwal_teknisis.status', ['open','pending'])
        ->count();

    // Tugas hari ini
    $tugasHariIni = \DB::table('jadwal_teknisi_user')
        ->join('jadwal_teknisis', 'jadwal_teknisi_user.jadwal_teknisi_id', '=', 'jadwal_teknisis.id')
        ->where('jadwal_teknisi_user.teknisi_id', $userId)
        ->where('jadwal_teknisis.tanggal', $hariIni)
        ->count();

    // Tabel tugas terbaru (10 terakhir)
    $tugasTerbaru = \DB::table('jadwal_teknisi_user')
        ->join('jadwal_teknisis', 'jadwal_teknisi_user.jadwal_teknisi_id', '=', 'jadwal_teknisis.id')
        ->leftJoin('pelanggans', 'jadwal_teknisis.pelanggan_id', '=', 'pelanggans.id')
        ->where('jadwal_teknisi_user.teknisi_id', $userId)
        ->select('jadwal_teknisis.no_tiket', 'jadwal_teknisis.jenis_tugas', 'pelanggans.nama as nama_pelanggan', 'pelanggans.alamat as lokasi', 'jadwal_teknisis.tanggal', 'jadwal_teknisis.status')
        ->orderByDesc('jadwal_teknisis.tanggal')
        ->limit(10)
        ->get();

    return view('dashboard.teknisi', compact(
        'totalTugasBulanIni',
        'tugasSelesaiBulanIni',
        'tugasBelumSelesai',
        'tugasHariIni',
        'tugasTerbaru'
    ));
}
}