<?php

namespace App\Http\Controllers;

use App\Models\Site;
use Illuminate\Http\Request;

class SiteController extends Controller
{
    public function index()
    {
        $sites = Site::orderBy('nama_site')->paginate(10); // 10 per halaman, bebas mau berapa
        return view('site.index', compact('sites'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'nama_site' => 'required|string|max:100',
            'lokasi_site' => 'nullable|string|max:150',
            'keterangan' => 'nullable|string',
        ]);
        Site::create($request->only('nama_site', 'lokasi_site', 'keterangan'));
        return redirect()->route('sites.index')->with('success', 'Site berhasil ditambahkan.');
    }

    public function update(Request $request, Site $site)
    {
        $request->validate([
            'nama_site' => 'required|string|max:100',
            'lokasi_site' => 'nullable|string|max:150',
            'keterangan' => 'nullable|string',
        ]);
        $site->update($request->only('nama_site', 'lokasi_site', 'keterangan'));
        return redirect()->route('sites.index')->with('success', 'Site berhasil diupdate.');
    }

    public function destroy(Site $site)
    {
        $site->delete();
        return redirect()->route('sites.index')->with('success', 'Site berhasil dihapus.');
    }
}