<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\JadwalTeknisiUser;
use App\Models\User;
use App\Models\Pelanggan;

class RekapUpahController extends Controller
{
    public function index(Request $request)
    {
        $query = JadwalTeknisiUser::with(['jadwalTeknisi.pelanggan', 'teknisi'])
            ->whereNotNull('nominal_upah')
            ->where('nominal_upah', '>', 0);

        // Filter tanggal
        if ($request->filled('tanggal')) {
            $query->whereHas('jadwalTeknisi', function($q) use($request){
                $q->where('tanggal', $request->tanggal);
            });
        }

        // Filter per bulan
        if ($request->filled('bulan')) {
            [$tahun, $bulan] = explode('-', $request->bulan);
            $query->whereHas('jadwalTeknisi', function($q) use($tahun, $bulan){
                $q->whereYear('tanggal', $tahun)->whereMonth('tanggal', $bulan);
            });
        }

        // Filter teknisi
        if ($request->filled('teknisi_id')) {
            $query->where('teknisi_id', $request->teknisi_id);
        }

        // Filter nama pelanggan
        if ($request->filled('nama_pelanggan')) {
            $query->whereHas('jadwalTeknisi.pelanggan', function($q) use($request){
                $q->where('nama', 'like', '%'.$request->nama_pelanggan.'%');
            });
        }

        // Filter status validasi
        if ($request->filled('status_validasi')) {
            $query->where('status_validasi', $request->status_validasi);
        }

        $teknisis = User::all();
        $totalUpah = $query->sum('nominal_upah');
        $rekapUpah = $query->orderByDesc('feedback_at')->paginate($request->input('per_page', 50));

        return view('rekap_upah.index', compact('rekapUpah', 'teknisis', 'totalUpah'));
    }
}