<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Pembayaran;
use App\Models\Grub;
use App\Models\User; // As penagih

class RekapPembayaranController extends Controller
{
    public function index(Request $request)
    {
        $query = Pembayaran::with(['pelanggan.grub', 'pelanggan.penagih']);

        // Filter Nama
        if ($request->filled('nama')) {
            $query->whereHas('pelanggan', function($q) use($request){
                $q->where('nama', 'like', '%'.$request->nama.'%');
            });
        }

        // Filter Grub
        if ($request->filled('grub_id')) {
            $query->whereHas('pelanggan', function($q) use($request){
                $q->where('grub_id', $request->grub_id);
            });
        }

        // Filter Status
        if ($request->filled('status')) {
            $query->where('status', $request->status);
        }

        // Filter Periode (bulan-tahun)
        if ($request->filled('periode')) {
            $query->where('periode', $request->periode);
        }

        // Filter tanggal bayar
        if ($request->filled('tanggal_bayar')) {
            $query->whereDate('tanggal_bayar', $request->tanggal_bayar);
        }

        // Filter Penagih
        $penagihs = User::role('penagihan')->get();
        if ($request->filled('penagih_id')) {
            $query->whereHas('pelanggan', function($q) use($request){
                $q->where('penagih_id', $request->penagih_id);
            });
        }

        $totalTagihan = $query->sum('jumlah_tagihan');
        $totalDibayar = $query->sum('jumlah_dibayar');
        $pembayarans = $query->orderByDesc('periode')->paginate(50);

        $grubs = Grub::all();
        //$penagihs = User::all();


        return view('rekap_pembayaran.index', compact('pembayarans', 'grubs', 'penagihs', 'totalTagihan', 'totalDibayar'));
    }
}