<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\JadwalTeknisiUser;
use App\Models\User; // teknisi
use App\Models\Pelanggan; // pelanggan

class RekapKasController extends Controller
{
    public function index(Request $request)
    {
        $query = JadwalTeknisiUser::with(['jadwalTeknisi.pelanggan', 'teknisi'])
            ->whereNotNull('nominal_bayar')
            ->where('nominal_bayar', '>', 0);

        // Filter tanggal
        if ($request->filled('tanggal')) {
            $query->whereHas('jadwalTeknisi', function($q) use($request){
                $q->where('tanggal', $request->tanggal);
            });
        }

        // Filter teknisi
        if ($request->filled('teknisi_id')) {
            $query->where('teknisi_id', $request->teknisi_id);
        }

 // Filter nama pelanggan
if ($request->filled('nama_pelanggan')) {
    $query->whereHas('jadwalTeknisi.pelanggan', function($q) use($request){
        $q->where('nama', 'like', '%'.$request->nama_pelanggan.'%');
    });
}

        // Filter per bulan
if ($request->filled('bulan')) {
    // Format value "2025-09"
    [$tahun, $bulan] = explode('-', $request->bulan);
    $query->whereHas('jadwalTeknisi', function($q) use($tahun, $bulan){
        $q->whereYear('tanggal', $tahun)->whereMonth('tanggal', $bulan);
    });
}

        // Filter metode bayar
        if ($request->filled('metode_bayar')) {
            $query->where('metode_bayar', $request->metode_bayar);
        }

        // Filter status validasi
        if ($request->filled('status_validasi')) {
            $query->where('status_validasi', $request->status_validasi);
        }

        $teknisis = User::all();
        $pelanggans = Pelanggan::all();
        $totalpemasukan = $query->sum('nominal_bayar');
        $rekapKas = $query->orderByDesc('feedback_at')->paginate($request->input('per_page', 50));

        return view('rekap_kas.index', compact('rekapKas', 'teknisis', 'pelanggans','totalpemasukan'));
    }
}