<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class QrController extends Controller
{
    /**
     * Download QR code as PNG
     */
    public function download(Request $request)
    {
        $text = $request->text ?? '';
        $name = $request->name ?? 'qr-pelanggan';

        // Generate QR PNG (GD backend, size 300px)
        $png = QrCode::format('png')->size(300)->generate($text);

        $filename = $name . '.png';
        return response($png, 200)
            ->header('Content-Type', 'image/png')
            ->header('Content-Disposition', 'attachment; filename="' . $filename . '"');
    }

    /**
     * Show QR code in printable view (new tab, with name below)
     */
    public function print(Request $request)
    {
        $text = $request->text ?? '';
        $name = $request->name ?? 'qr-pelanggan';
        $alamat = $request->alamat ?? '-';
        return view('qr.print', compact('text', 'name', 'alamat'));
    }
}