<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use DB;

class PenagihanDashboardController extends Controller
{
    public function index()
    {
        $periode = Carbon::now()->format('Y-m'); // Bulan ini
        $userId = auth()->id(); // Ambil ID user yang login

        // Ambil ID pelanggan yang penagihnya adalah user ini
        $pelangganIds = DB::table('pelanggans')
            ->where('penagih_id', $userId)
            ->pluck('id')
            ->toArray();

        // Total tagihan bulan ini (hanya untuk pelanggan yang ditagih user ini)
        $totalTagihanBulanIni = DB::table('pembayarans')
            ->where('periode', $periode)
            ->whereIn('pelanggan_id', $pelangganIds)
            ->sum('jumlah_tagihan');

        // Tagihan sudah dibayar bulan ini
        $tagihanSudahDibayar = DB::table('pembayarans')
            ->where('periode', $periode)
            ->where('status', 'lunas')
            ->whereIn('pelanggan_id', $pelangganIds)
            ->sum('jumlah_tagihan');

        // Tagihan belum dibayar bulan ini
        $tagihanBelumDibayar = DB::table('pembayarans')
            ->where('periode', $periode)
            ->where('status', 'belum_lunas')
            ->whereIn('pelanggan_id', $pelangganIds)
            ->sum('jumlah_tagihan');

        // Jumlah pelanggan suspend
        $jumlahSuspend = DB::table('pelanggans')
            ->where('penagih_id', $userId)
            ->where('status', 'suspend')
            ->count();

        // Jumlah pelanggan belum bayar bulan ini
        $jumlahBelumBayar = DB::table('pembayarans')
            ->where('periode', $periode)
            ->where('status', 'belum_lunas')
            ->whereIn('pelanggan_id', $pelangganIds)
            ->count();

        // Daftar pelanggan belum lunas bulan ini
        $pelangganBelumLunas = DB::table('pembayarans')
            ->join('pelanggans', 'pembayarans.pelanggan_id', '=', 'pelanggans.id')
            ->leftJoin('grubs', 'pelanggans.grub_id', '=', 'grubs.id')
            ->where('pembayarans.periode', $periode)
            ->where('pembayarans.status', 'belum_lunas')
            ->whereIn('pelanggans.id', $pelangganIds)
            ->select(
                'pelanggans.nama',
                'pelanggans.alamat',
                'pelanggans.no_hp',
                'pelanggans.paket_wifi',
                'pelanggans.foto_rumah',
                'pelanggans.status',
                'grubs.nama_grub',
                'pembayarans.jumlah_tagihan',
                'pembayarans.status'
            )
            ->orderBy('pelanggans.nama')
            ->get();

        return view('dashboard.penagihan', compact(
            'totalTagihanBulanIni',
            'tagihanSudahDibayar',
            'tagihanBelumDibayar',
            'jumlahSuspend',
            'jumlahBelumBayar',
            'pelangganBelumLunas'
        ));
    }
}