<?php

namespace App\Http\Controllers;

use App\Models\Pembayaran;
use Illuminate\Http\Request;

class PembayaranController extends Controller
{
    public function tagihanPelanggan($pelanggan_id)
    {
        $pelanggan = Pelanggan::with('pembayaran')->findOrFail($pelanggan_id);
        return view('pelanggan.tagihan', compact('pelanggan'));
    }

    public function generateTagihan()
    {
        $periode = \Carbon\Carbon::now()->format('Y-m');
        // Hanya ambil pelanggan yang statusnya aktif
        $pelanggans = \App\Models\Pelanggan::where('status', 'aktif')->get();
    
        $count = 0;
        foreach ($pelanggans as $pelanggan) {
            $existing = $pelanggan->pembayaran()->where('periode', $periode)->first();
            if (!$existing) {
                \App\Models\Pembayaran::create([
                    'pelanggan_id' => $pelanggan->id,
                    'periode'        => $periode,
                    'jumlah_tagihan'       => $pelanggan->paket_wifi,
                    'status'       => 'belum_lunas'
                ]);
                $count++;
            }
        }
    
        return redirect()->route('pelanggan.index')->with('success', "Tagihan baru berhasil dibuat untuk $count pelanggan!");
    }

public function bayar($id)
{
    $tagihan = \App\Models\Pembayaran::findOrFail($id);
    $tagihan->status = 'lunas';
    $tagihan->save();

    return redirect()->route('pelanggan.index')->with('success', 'Tagihan berhasil dibayar!');
}

public function bayarCicilan(Request $request, $id)
{
    $pembayaran = Pembayaran::findOrFail($id);

    $jumlah_bayar = intval($request->jumlah_bayar);
    if ($jumlah_bayar <= 0) {
        return back()->with('error', 'Nominal cicilan harus lebih dari 0');
    }

    // Tambah nominal ke jumlah_dibayar
    $pembayaran->jumlah_dibayar += $jumlah_bayar;

    // Update status lunas jika sudah cukup
    if ($pembayaran->jumlah_dibayar >= $pembayaran->jumlah_tagihan) {
        $pembayaran->status = 'lunas';
        $pembayaran->jumlah_dibayar = $pembayaran->jumlah_tagihan; // pastikan tidak lebih dari tagihan
    } else {
        $pembayaran->status = 'belum_lunas';
    }

    // Tambahkan ini untuk update tanggal pembayaran!
    $pembayaran->tanggal_bayar = now();

    $pembayaran->save();

    return back()->with('success', 'Pembayaran cicilan berhasil!');
}

public function index(Request $request)
{
    $userId = auth()->id(); // id petugas penagih yang sedang login

    $pembayarans = \App\Models\Pembayaran::with(['pelanggan.grub'])
        ->whereHas('pelanggan', function($query) use ($userId, $request) {
            $query->where('penagih_id', $userId);
            // Filter grub jika request ada grub_id
            if ($request->filled('grub_id')) {
                $query->where('grub_id', $request->grub_id);
            }
            // filter tambahan pencarian
            if ($request->filled('q')) {
                $query->where(function($q) use ($request) {
                    $q->where('nama', 'like', '%' . $request->q . '%')
                    ->orWhere('alamat', 'like', '%' . $request->q . '%')
                    ->orWhere('no_hp', 'like', '%' . $request->q . '%');
                });
            }
        });

    if ($request->filled('status')) {
        $pembayarans = $pembayarans->where('status', $request->status);
    }

    $pembayarans = $pembayarans->orderBy('periode', 'desc')->paginate(10);

    // Untuk filter grub di blade
    $grubs = \App\Models\Grub::all();

    return view('pembayaran.index', compact('pembayarans', 'grubs'));
}

}