<?php

namespace App\Http\Controllers;

use App\Models\PaketInternet;
use Illuminate\Http\Request;

class PaketInternetController extends Controller
{
    public function index(Request $request)
    {
        $sort = $request->get('sort', 'nama_paket'); // default sort by nama_paket
        $direction = $request->get('direction', 'asc'); // default ascending
    
        // Validasi kolom sort agar tidak injection
        $allowedSorts = ['nama_paket', 'harga'];
        if (!in_array($sort, $allowedSorts)) $sort = 'nama_paket';
        if (!in_array($direction, ['asc','desc'])) $direction = 'asc';
    
        $pakets = \App\Models\PaketInternet::orderBy($sort, $direction)->paginate(10);
        return view('paket_internet.index', compact('pakets', 'sort', 'direction'));
    }

    public function create()
    {
        return view('paket_internet.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nama_paket' => 'required|string|max:255',
            'harga' => 'required|integer|min:0',
        ]);
        PaketInternet::create($request->only(['nama_paket', 'harga']));
        return redirect()->route('paket_internet.index')->with('success', 'Paket berhasil ditambahkan!');
    }

    public function edit($id)
    {
        $paket = PaketInternet::findOrFail($id);
        return view('paket_internet.edit', compact('paket'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'nama_paket' => 'required|string|max:255',
            'harga' => 'required|integer|min:0',
        ]);
        $paket = PaketInternet::findOrFail($id);
        $paket->update($request->only(['nama_paket', 'harga']));
        return redirect()->route('paket_internet.index')->with('success', 'Paket berhasil diupdate!');
    }

    public function destroy($id)
    {
        $paket = PaketInternet::findOrFail($id);
        $paket->delete();
        return redirect()->route('paket_internet.index')->with('success', 'Paket berhasil dihapus!');
    }
}