<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Pelanggan;
use App\Models\Site;

class ListPelangganController extends Controller
{
    public function index(Request $request)
    {
        $query = Pelanggan::with(['site', 'grub']);
    
        // Filter status aktif/suspend
        if ($request->filled('status') && in_array($request->status, ['aktif', 'suspend'])) {
            $query->where('status', $request->status);
        }
    
        // Search filter
        if ($request->filled('search')) {
            $search = $request->search;
            $query->where(function($q) use ($search) {
                $q->where('nama', 'like', "%$search%")
                  ->orWhere('ip_address', 'like', "%$search%")
                  ->orWhere('pppoe_username', 'like', "%$search%")
                  ->orWhereHas('site', function($s) use ($search) {
                        $s->where('nama_site', 'like', "%$search%");
                    })
                  ->orWhereHas('grub', function($g) use ($search) {
                        $g->where('nama_grub', 'like', "%$search%");
                    });
            });
        }
    
        // Sorting
        $sort = $request->get('sort', 'nama'); // default sort by nama
        $direction = $request->get('direction', 'asc');
    
        // Sorting by related fields
        if ($sort == 'site') {
            $query->leftJoin('sites', 'sites.id', '=', 'pelanggans.site_id')
                  ->orderBy('sites.nama_site', $direction)
                  ->select('pelanggans.*');
        } elseif ($sort == 'grub') {
            $query->leftJoin('grubs', 'grubs.id', '=', 'pelanggans.grub_id')
                  ->orderBy('grubs.nama_grub', $direction)
                  ->select('pelanggans.*');
        } elseif ($sort == 'status') {
            $query->orderBy('status', $direction);
        } else {
            $query->orderBy($sort, $direction);
        }
    
        $pelanggans = $query->paginate(10)->appends($request->except('page'));
    
        return view('pelanggan.list', compact('pelanggans', 'sort', 'direction'));
    }
}