<?php

namespace App\Http\Controllers;

use App\Models\Grub;
use Illuminate\Http\Request;

class GrubController extends Controller
{
    public function index()
    {
        $grubs = Grub::all();
        return view('grub.index', compact('grubs'));
    }

    public function create()
    {
        return view('grub.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nama_grub' => 'required|string|max:255',
            'keterangan' => 'nullable|string',
        ]);
        Grub::create($request->all());
        return redirect()->route('grubs.index')->with('success', 'Grub berhasil ditambahkan');
    }

    public function edit(Grub $grub)
    {
        return view('grub.edit', compact('grub'));
    }

    public function update(Request $request, Grub $grub)
    {
        $request->validate([
            'nama_grub' => 'required|string|max:255',
            'keterangan' => 'nullable|string',
        ]);
        $grub->update($request->all());
        return redirect()->route('grubs.index')->with('success', 'Grub berhasil diupdate');
    }

    public function destroy(Grub $grub)
    {
        $grub->delete();
        return redirect()->route('grubs.index')->with('success', 'Grub berhasil dihapus');
    }

    public function show($id)
{
    $grub = \App\Models\Grub::with(['pelanggans.pembayaran'])->findOrFail($id);
    return view('grub.show', compact('grub'));
}
}